/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RancherBee
extends ProductiveBee {
    public PathfinderMob target = null;
    public static Predicate<Entity> predicate = entity -> entity.m_6095_().m_204039_(ModTags.RANCHABLES);

    public RancherBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, 1);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.target != null) {
            if (!this.m_27856_()) {
                this.target.m_21573_().m_26517_(0.0);
            } else {
                this.target.m_6710_((LivingEntity)this);
                this.target = null;
            }
        }
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    public boolean m_27896_(BlockPos pos) {
        if (!this.m_9236_().m_46749_(pos)) {
            return false;
        }
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof AmberBlockEntity) {
            AmberBlockEntity amberBlockEntity = (AmberBlockEntity)blockEntity;
            Entity entity = amberBlockEntity.getCachedEntity();
            return entity != null && entity.m_6095_().m_204039_(ModTags.RANCHABLES);
        }
        List entities = this.m_9236_().m_6249_((Entity)this, new AABB(pos).m_82377_(1.0, 1.0, 1.0), predicate);
        if (!entities.isEmpty()) {
            this.target = (PathfinderMob)entities.get(0);
            this.target.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 400));
            return true;
        }
        return RancherBee.isValidFeeder(this, this.m_9236_().m_7702_(pos), this::isFlowerBlock, this::isFlowerItem);
    }

    @Override
    public void postPollinate() {
        Shearable sheep;
        super.postPollinate();
        PathfinderMob pathfinderMob = this.target;
        if (pathfinderMob instanceof Shearable && (sheep = (Shearable)pathfinderMob).m_6220_()) {
            sheep.m_5851_(SoundSource.BLOCKS);
        }
    }

    @Override
    public boolean isFlowerBlock(BlockState flowerBlock) {
        return false;
    }

    @Override
    public String getFlowerType() {
        return "entity_type";
    }
}

