/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;

public class ItemConversionRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final List<Lazy<BeeIngredient>> bees;
    public Ingredient ingredient;
    public ItemStack output;
    public final int chance;
    public final boolean pollinates;

    public ItemConversionRecipe(ResourceLocation id, List<Lazy<BeeIngredient>> bees, Ingredient ingredient, ItemStack output, int chance, boolean pollinates) {
        this.id = id;
        this.bees = bees;
        this.ingredient = ingredient;
        this.output = output;
        this.chance = chance;
        this.pollinates = pollinates;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv instanceof BeeHelper.ItemInventory && this.bees.size() > 0) {
            String beeName = ((BeeHelper.ItemInventory)inv).getIdentifier(0);
            ItemStack inputItem = ((BeeHelper.ItemInventory)inv).getInput();
            boolean matchesInput = this.ingredient.test(inputItem);
            boolean matchesBee = false;
            for (Lazy<BeeIngredient> bee : this.bees) {
                matchesBee = matchesBee || ((BeeIngredient)bee.get()).getBeeType().toString().equals(beeName);
            }
            return matchesBee && matchesInput;
        }
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public List<BeeIngredient> getBees() {
        ArrayList<BeeIngredient> list = new ArrayList<BeeIngredient>();
        this.bees.forEach(bee -> list.add((BeeIngredient)bee.get()));
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.ITEM_CONVERSION.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.ITEM_CONVERSION_TYPE.get();
    }

    public static class Serializer<T extends ItemConversionRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            ArrayList<Lazy<BeeIngredient>> bees = new ArrayList<Lazy<BeeIngredient>>();
            if (json.has("bee")) {
                String source = GsonHelper.m_13906_((JsonObject)json, (String)"bee");
                Lazy sourceBee = Lazy.of(BeeIngredientFactory.getIngredient(source));
                bees.add(sourceBee);
            } else if (json.has("bees")) {
                JsonArray beeArray = GsonHelper.m_13933_((JsonObject)json, (String)"bees");
                beeArray.forEach(jsonElement -> {
                    Lazy sourceBee = Lazy.of(BeeIngredientFactory.getIngredient(jsonElement.getAsString()));
                    bees.add(sourceBee);
                });
            }
            Ingredient input = GsonHelper.m_13885_((JsonObject)json, (String)"ingredients") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredients"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)100);
            boolean pollinates = GsonHelper.m_13855_((JsonObject)json, (String)"pollinates", (boolean)false);
            return this.factory.create(id, bees, input, output, chance, pollinates);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                int beeCount = buffer.readInt();
                ArrayList<Lazy<BeeIngredient>> bees = new ArrayList<Lazy<BeeIngredient>>();
                for (int i = 0; i < beeCount; ++i) {
                    BeeIngredient source = BeeIngredient.fromNetwork(buffer);
                    bees.add(Lazy.of(() -> source));
                }
                return this.factory.create(id, bees, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130267_(), buffer.readInt(), buffer.readBoolean());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading item conversion recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                buffer.writeInt(((ItemConversionRecipe)recipe).bees.size());
                ((ItemConversionRecipe)recipe).bees.forEach(bee -> ((BeeIngredient)bee.get()).toNetwork(buffer));
                ((ItemConversionRecipe)recipe).ingredient.m_43923_(buffer);
                buffer.m_130055_(((ItemConversionRecipe)recipe).output);
                buffer.writeInt(((ItemConversionRecipe)recipe).chance);
                buffer.writeBoolean(((ItemConversionRecipe)recipe).pollinates);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing item conversion recipe to packet. " + ((ItemConversionRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends ItemConversionRecipe> {
            public T create(ResourceLocation var1, List<Lazy<BeeIngredient>> var2, Ingredient var3, ItemStack var4, int var5, boolean var6);
        }
    }
}

