/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.twigs.block;

import com.ninni.twigs.TwigsProperties;
import com.ninni.twigs.TwigsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final BooleanProperty LEG1 = TwigsProperties.TABLE_LEG1;
    private static final BooleanProperty LEG2 = TwigsProperties.TABLE_LEG2;
    private static final BooleanProperty LEG3 = TwigsProperties.TABLE_LEG3;
    private static final BooleanProperty LEG4 = TwigsProperties.TABLE_LEG4;
    public static final BooleanProperty UPDATE = BooleanProperty.m_61465_((String)"update");
    protected static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_1 = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0);
    protected static final VoxelShape LEG_2 = Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0);
    protected static final VoxelShape LEG_3 = Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0);
    protected static final VoxelShape LEG_4 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{TOP, Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_1), Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_2), Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_3), Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_4), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_3, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3, LEG_4})};

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean leg1 = (Boolean)state.m_61143_((Property)LEG1);
        boolean leg2 = (Boolean)state.m_61143_((Property)LEG2);
        boolean leg3 = (Boolean)state.m_61143_((Property)LEG3);
        boolean leg4 = (Boolean)state.m_61143_((Property)LEG4);
        int shape = 0;
        if (leg2) {
            shape = 1;
        }
        if (leg3) {
            shape = 2;
        }
        if (leg1) {
            shape = 3;
        }
        if (leg4) {
            shape = 4;
        }
        if (leg2 && leg3) {
            shape = 5;
        }
        if (leg2 && leg1) {
            shape = 6;
        }
        if (leg2 && leg4) {
            shape = 7;
        }
        if (leg3 && leg1) {
            shape = 8;
        }
        if (leg3 && leg4) {
            shape = 9;
        }
        if (leg1 && leg4) {
            shape = 10;
        }
        if (leg2 && leg3 && leg1) {
            shape = 11;
        }
        if (leg2 && leg3 && leg4) {
            shape = 12;
        }
        if (leg2 && leg1 && leg4) {
            shape = 13;
        }
        if (leg3 && leg1 && leg4) {
            shape = 14;
        }
        if (leg2 && leg3 && leg1 && leg4) {
            shape = 15;
        }
        return SHAPES[shape];
    }

    public BlockState getConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = this.canConnect(level.m_8055_(pos.m_122012_()));
        boolean south = this.canConnect(level.m_8055_(pos.m_122019_()));
        boolean east = this.canConnect(level.m_8055_(pos.m_122029_()));
        boolean west = this.canConnect(level.m_8055_(pos.m_122024_()));
        boolean update = ((north ? 1 : 0) + (east ? 1 : 0) + (south ? 1 : 0) + (west ? 1 : 0)) % 2 == 0;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(!north && !east || north && east && !this.canConnect(level.m_8055_(pos.m_122012_().m_122029_()))))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(!east && !south || east && south && !this.canConnect(level.m_8055_(pos.m_122019_().m_122029_()))))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(!west && !south || west && south && !this.canConnect(level.m_8055_(pos.m_122019_().m_122024_()))))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(!west && !north || west && north && !this.canConnect(level.m_8055_(pos.m_122012_().m_122024_()))))).m_61124_((Property)UPDATE, (Comparable)Boolean.valueOf(update));
    }

    public boolean canConnect(BlockState state) {
        return state.m_204336_(TwigsTags.TABLES_BLOCK);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        Player player = context.m_43723_();
        return player != null && player.m_6144_() ? state : this.getConnections(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getConnections(state, level, currentPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, UPDATE, LEG1, LEG2, LEG3, LEG4});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

