/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.model.forge;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.lowdragmc.lowdraglib.client.model.custommodel.CustomBakedModel;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LDLRendererModel
implements IUnbakedGeometry<LDLRendererModel> {
    public static final LDLRendererModel INSTANCE = new LDLRendererModel();

    private LDLRendererModel() {
    }

    public BakedModel bake(IGeometryBakingContext iGeometryBakingContext, ModelBaker arg, Function<Material, TextureAtlasSprite> function, ModelState arg2, ItemOverrides arg3, ResourceLocation arg4) {
        return new RendererBakedModel();
    }

    public static final class RendererBakedModel
    implements BakedModel {
        public static final ModelProperty<IRenderer> IRENDERER = new ModelProperty();
        public static final ModelProperty<BlockAndTintGetter> WORLD = new ModelProperty();
        public static final ModelProperty<BlockPos> POS = new ModelProperty();
        public static final ModelProperty<ModelData> MODEL_DATA = new ModelProperty();
        public static final ThreadLocal<ModelData> CURRENT_MODEL_DATA = new ThreadLocal();
        public static final ThreadLocal<RenderType> CURRENT_RENDER_TYPE = new ThreadLocal();

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
            return Collections.emptyList();
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            IRenderer renderer = (IRenderer)data.get(IRENDERER);
            BlockAndTintGetter world = (BlockAndTintGetter)data.get(WORLD);
            BlockPos pos = (BlockPos)data.get(POS);
            if (renderer != null) {
                CURRENT_MODEL_DATA.set(data);
                CURRENT_RENDER_TYPE.set(renderType);
                List<BakedQuad> quads = renderer.renderModel(world, pos, state, side, rand);
                if (renderer.reBakeCustomQuads() && state != null && world != null && pos != null) {
                    return CustomBakedModel.reBakeCustomQuads(quads, world, pos, state, side, renderer.reBakeCustomQuadsOffset());
                }
                CURRENT_MODEL_DATA.remove();
                CURRENT_RENDER_TYPE.remove();
                return quads;
            }
            return Collections.emptyList();
        }

        public boolean useAmbientOcclusion(BlockState state) {
            IBlockRendererProvider rendererProvider;
            IRenderer renderer;
            Block block = state.m_60734_();
            if (block instanceof IBlockRendererProvider && (renderer = (rendererProvider = (IBlockRendererProvider)block).getRenderer(state)) != null) {
                return renderer.useAO(state);
            }
            return this.m_7541_();
        }

        @NotNull
        public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
            IBlockRendererProvider rendererProvider;
            IRenderer renderer;
            Block block = state.m_60734_();
            if (block instanceof IBlockRendererProvider && (renderer = (rendererProvider = (IBlockRendererProvider)block).getRenderer(state)) != null) {
                modelData = ModelData.builder().with(IRENDERER, (Object)renderer).with(WORLD, (Object)level).with(POS, (Object)pos).with(MODEL_DATA, (Object)modelData).build();
            }
            return modelData;
        }

        public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
            IRenderer renderer = (IRenderer)data.get(IRENDERER);
            if (renderer != null) {
                CURRENT_MODEL_DATA.set(data);
                TextureAtlasSprite texture = renderer.getParticleTexture();
                CURRENT_MODEL_DATA.remove();
                return texture;
            }
            return super.getParticleIcon(data);
        }
    }

    public static final class Loader
    implements IGeometryLoader<LDLRendererModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public LDLRendererModel read(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return INSTANCE;
        }
    }
}

