/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.renderer.impl;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIResourceRenderer
implements IRenderer {
    private static Resource<IRenderer> projectResource;
    private static boolean isProject;
    private Resource<IRenderer> resource;
    public final Either<String, File> key;

    public static void setCurrentResource(Resource<IRenderer> resource, boolean isProject) {
        projectResource = resource;
        UIResourceRenderer.isProject = isProject;
    }

    public static void clearCurrentResource() {
        projectResource = null;
        isProject = false;
    }

    public UIResourceRenderer(Either<String, File> key) {
        this.key = key;
    }

    public UIResourceRenderer(Resource<IRenderer> resource, Either<String, File> key) {
        this.resource = resource;
        this.key = key;
    }

    public IRenderer getRenderer() {
        return this.resource == null ? IRenderer.EMPTY : this.resource.getResourceOrDefault(this.key, IRenderer.EMPTY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        this.getRenderer().renderItem(stack, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, model);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> renderModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getRenderer().renderModel(level, pos, state, side, rand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        this.getRenderer().onPrepareTextureAtlas(atlasName, register);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onAdditionalModel(Consumer<ResourceLocation> registry) {
        this.getRenderer().onAdditionalModel(registry);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerEvent() {
        this.getRenderer().registerEvent();
    }

    @Override
    public boolean isRaw() {
        return this.getRenderer().isRaw();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return this.getRenderer().hasTESR(blockEntity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return this.getRenderer().isGlobalRenderer(blockEntity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return this.getRenderer().getViewDistance();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(BlockEntity blockEntity, Vec3 cameraPos) {
        return this.getRenderer().shouldRender(blockEntity, cameraPos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        this.getRenderer().render(blockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public TextureAtlasSprite getParticleTexture() {
        return this.getRenderer().getParticleTexture();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useAO() {
        return this.getRenderer().useAO();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useAO(BlockState state) {
        return this.getRenderer().useAO(state);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useBlockLight(ItemStack stack) {
        return this.getRenderer().useBlockLight(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean reBakeCustomQuads() {
        return this.getRenderer().reBakeCustomQuads();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float reBakeCustomQuadsOffset() {
        return this.getRenderer().reBakeCustomQuadsOffset();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isGui3d() {
        return this.getRenderer().isGui3d();
    }

    public static Resource<IRenderer> getProjectResource() {
        return projectResource;
    }

    public static boolean isProject() {
        return isProject;
    }

    public void setResource(Resource<IRenderer> resource) {
        this.resource = resource;
    }
}

