/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.utils;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtils {
    private static final Stack<int[]> scissorFrameStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void useScissor(int x, int y, int width, int height, Runnable codeBlock) {
        RenderUtils.pushScissorFrame(x, y, width, height);
        try {
            codeBlock.run();
        }
        finally {
            RenderUtils.popScissorFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void useScissor(@Nonnull PoseStack poseStack, int x, int y, int width, int height, Runnable codeBlock) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Vector4f pos = pose.transform(new Vector4f((float)x, (float)y, 0.0f, 1.0f));
        Vector4f size = pose.transform(new Vector4f((float)(x + width), (float)(y + height), 0.0f, 1.0f));
        x = (int)pos.x();
        y = (int)pos.y();
        width = (int)(size.x() - (float)x);
        height = (int)(size.y() - (float)y);
        RenderUtils.pushScissorFrame(x, y, width, height);
        try {
            codeBlock.run();
        }
        finally {
            RenderUtils.popScissorFrame();
        }
    }

    private static int[] peekFirstScissorOrFullScreen() {
        int[] currentTopFrame;
        int[] nArray = currentTopFrame = scissorFrameStack.isEmpty() ? null : scissorFrameStack.peek();
        if (currentTopFrame == null) {
            Window window = Minecraft.m_91087_().m_91268_();
            return new int[]{0, 0, window.m_85441_(), window.m_85442_()};
        }
        return currentTopFrame;
    }

    private static void pushScissorFrame(int x, int y, int width, int height) {
        int[] parentScissor = RenderUtils.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        boolean pushedFrame = false;
        if (x <= parentX + parentWidth && y <= parentY + parentHeight) {
            int newX = Math.max(x, parentX);
            int newY = Math.max(y, parentY);
            int newWidth = width - (newX - x);
            int newHeight = height - (newY - y);
            if (newWidth > 0 && newHeight > 0) {
                int maxWidth = parentWidth - (x - parentX);
                int maxHeight = parentHeight - (y - parentY);
                newWidth = Math.min(maxWidth, newWidth);
                newHeight = Math.min(maxHeight, newHeight);
                RenderUtils.applyScissor(newX, newY, newWidth, newHeight);
                if (scissorFrameStack.isEmpty()) {
                    GL11.glEnable((int)3089);
                }
                scissorFrameStack.push(new int[]{newX, newY, newWidth, newHeight});
                pushedFrame = true;
            }
        }
        if (!pushedFrame) {
            if (scissorFrameStack.isEmpty()) {
                GL11.glEnable((int)3089);
            }
            scissorFrameStack.push(new int[]{parentX, parentY, parentWidth, parentHeight});
        }
    }

    private static void popScissorFrame() {
        scissorFrameStack.pop();
        int[] parentScissor = RenderUtils.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        RenderUtils.applyScissor(parentX, parentY, parentWidth, parentHeight);
        if (scissorFrameStack.isEmpty()) {
            GL11.glDisable((int)3089);
        }
    }

    private static void applyScissor(int x, int y, int w, int h) {
        Window window = Minecraft.m_91087_().m_91268_();
        double s = window.m_85449_();
        int translatedY = window.m_85446_() - y - h;
        GL11.glScissor((int)((int)((double)x * s)), (int)((int)((double)translatedY * s)), (int)((int)((double)w * s)), (int)((int)((double)h * s)));
    }

    public static void useStencil(Runnable mask, Runnable renderInMask, boolean shouldRenderMask) {
        GL11.glStencilMask((int)255);
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        if (!shouldRenderMask) {
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GL11.glDepthMask((boolean)false);
        }
        mask.run();
        if (!shouldRenderMask) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glDepthMask((boolean)true);
        }
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        renderInMask.run();
        GL11.glDisable((int)2960);
    }

    public static void renderBlockOverLay(@Nonnull PoseStack poseStack, BlockPos pos, float r, float g, float b, float scale) {
        if (pos == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        poseStack.m_85836_();
        poseStack.m_85837_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        poseStack.m_85841_(scale, scale, scale);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtils.renderCubeFace(poseStack, buffer, -0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, r, g, b, 1.0f);
        tessellator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderCubeFace(PoseStack poseStack, BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float r, float g, float b, float a) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(mat, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
    }

    public static void moveToFace(PoseStack poseStack, double x, double y, double z, Direction face) {
        poseStack.m_85837_(x + 0.5 + (double)face.m_122429_() * 0.5, y + 0.5 + (double)face.m_122430_() * 0.5, z + 0.5 + (double)face.m_122431_() * 0.5);
    }

    public static void rotateToFace(PoseStack poseStack, Direction face, @Nullable Direction spin) {
        float angle = spin == Direction.EAST ? 1.5707964f : (spin == Direction.SOUTH ? (float)Math.PI : (spin == Direction.WEST ? -1.5707964f : 0.0f));
        switch (face) {
            case UP: {
                poseStack.m_85841_(1.0f, -1.0f, 1.0f);
                poseStack.m_252781_(new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)));
                poseStack.m_252781_(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case DOWN: {
                poseStack.m_85841_(1.0f, -1.0f, 1.0f);
                poseStack.m_252781_(new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)));
                poseStack.m_252781_(new Quaternionf().rotateAxis(spin == Direction.EAST ? 1.5707964f : (spin == Direction.NORTH ? (float)Math.PI : (spin == Direction.WEST ? -1.5707964f : 0.0f)), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case EAST: {
                poseStack.m_85841_(-1.0f, -1.0f, -1.0f);
                poseStack.m_252781_(new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
                poseStack.m_252781_(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case WEST: {
                poseStack.m_85841_(-1.0f, -1.0f, -1.0f);
                poseStack.m_252781_(new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
                poseStack.m_252781_(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case NORTH: {
                poseStack.m_85841_(-1.0f, -1.0f, -1.0f);
                poseStack.m_252781_(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case SOUTH: {
                poseStack.m_85841_(-1.0f, -1.0f, -1.0f);
                poseStack.m_252781_(new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
                poseStack.m_252781_(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
        }
    }
}

