/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.compass.CompassNode;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.json.SimpleIGuiTextureJsonUtils;
import com.mojang.realmsclient.util.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CompassSection {
    private final JsonObject config;
    public ResourceLocation sectionName;
    public int priority;
    public final Map<ResourceLocation, CompassNode> nodes;
    protected IGuiTexture buttonTexture;
    protected IGuiTexture backgroundTexture;

    public CompassSection(ResourceLocation sectionName, JsonObject config) {
        this.config = config;
        this.sectionName = sectionName;
        this.nodes = new HashMap<ResourceLocation, CompassNode>();
        this.priority = JsonUtils.m_90153_((String)"priority", (JsonObject)config, (int)0);
        this.setButtonTexture(SimpleIGuiTextureJsonUtils.fromJson(config.get("button_texture").getAsJsonObject()));
        this.setBackgroundTexture(config.has("background_texture") ? SimpleIGuiTextureJsonUtils.fromJson(config.get("background_texture").getAsJsonObject()) : null);
    }

    public JsonObject updateJson() {
        this.config.addProperty("priority", (Number)this.priority);
        this.config.add("button_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.buttonTexture));
        if (this.backgroundTexture != null) {
            this.config.add("background_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.backgroundTexture));
        }
        return this.config;
    }

    public void addNode(CompassNode compassNode) {
        this.nodes.put(compassNode.getNodeName(), compassNode);
    }

    public final String toString() {
        return this.sectionName.toString();
    }

    public CompassNode getNode(ResourceLocation nodeName) {
        return this.nodes.get(nodeName);
    }

    public Component getChatComponent() {
        return Component.m_237115_((String)this.sectionName.m_214296_("compass.section"));
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public ResourceLocation getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(ResourceLocation sectionName) {
        this.sectionName = sectionName;
    }

    public IGuiTexture getButtonTexture() {
        return this.buttonTexture;
    }

    public void setButtonTexture(IGuiTexture buttonTexture) {
        this.buttonTexture = buttonTexture;
    }

    public IGuiTexture getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public void setBackgroundTexture(IGuiTexture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
    }
}

