/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.CompassNode;
import com.lowdragmc.lowdraglib.gui.compass.CompassSection;
import com.lowdragmc.lowdraglib.gui.compass.CompassView;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.ShaderTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.MenuWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.FileUtility;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;

public class CompassSectionWidget
extends WidgetGroup {
    protected final CompassView compassView;
    protected final CompassSection section;
    protected float xOffset;
    protected float yOffset;
    protected float scale = 1.0f;
    protected double lastMouseX;
    protected double lastMouseY;
    protected boolean isDragging = false;
    protected boolean editMode = false;
    protected WidgetGroup editModeWidget;
    protected Mode mode = Mode.CURSOR;
    protected int gridWidth = 50;
    protected boolean magnetic = true;
    @Nullable
    protected CompassNode selectedNode = null;
    protected Position originPosition = Position.ORIGIN;
    protected Pair<CompassNode, CompassNode> selectedLink = null;
    protected Set<CompassNode> removedNodes = new HashSet<CompassNode>();

    public CompassSectionWidget(CompassView compassView, CompassSection section) {
        super(0, 0, compassView.getSize().width - 150, compassView.getSize().height);
        this.compassView = compassView;
        this.section = section;
        this.resetFitScale();
        this.addWidget(new ButtonWidget(10, 10, 20, 20, new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture(), Icons.ROTATION), cd -> this.resetFitScale()).setHoverTooltips(new Component[]{Component.m_237115_((String)"ldlib.gui.compass.reset_view")}));
        if (CompassManager.INSTANCE.devMode) {
            this.addWidget(new SwitchWidget(40, 10, 20, 20, (cd, isPressed) -> this.setEditMode((boolean)isPressed)).setSupplier(() -> this.editMode).setTexture(new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture(), Icons.EDIT_OFF), new GuiTextureGroup(ColorPattern.T_CYAN.rectTexture(), Icons.EDIT_ON)).setHoverTooltips(new Component[]{Component.m_237115_((String)"ldlib.gui.compass.edit_mode")}));
        }
        this.editModeWidget = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget(this.editModeWidget);
        this.editModeWidget.setVisible(false);
        this.editModeWidget.setActive(false);
        this.editModeWidget.addWidget(new ButtonWidget(40, 30, 20, 20, new GuiTextureGroup(ColorPattern.T_RED.rectTexture(), Icons.SAVE), cd -> this.saveSection()).setHoverTooltips(new Component[]{Component.m_237115_((String)"ldlib.gui.editor.menu.save")}));
        TextBoxWidget textBox = new TextBoxWidget(this.getSize().width - 200, 10, 200, List.of("ldlib.gui.compass.mode.%s.tooltip".formatted(this.mode.name().toLowerCase()))).setFontColor(-1).setShadow(true);
        this.editModeWidget.addWidget(textBox);
        for (Mode mode : Mode.values()) {
            this.editModeWidget.addWidget(new ImageWidget(62 + 16 * mode.ordinal(), 32, 16, 16, () -> this.mode == mode ? ResourceBorderTexture.SELECTED.copy().setColor(ColorPattern.RED.color) : IGuiTexture.EMPTY));
            this.editModeWidget.addWidget(new ButtonWidget(62 + 16 * mode.ordinal(), 32, 16, 16, mode.icon, cd -> {
                this.switchMode(mode);
                textBox.setContent(List.of("ldlib.gui.compass.mode.%s.tooltip".formatted(mode.name().toLowerCase())));
            }).setHoverTexture(new GuiTextureGroup(ResourceBorderTexture.SELECTED.copy().setColor(ColorPattern.T_RED.color), mode.icon)).setHoverTooltips(new Component[]{Component.m_237115_((String)("ldlib.gui.compass.mode." + mode.name().toLowerCase()))}));
        }
    }

    private void saveSection() {
        File file;
        File path = new File(LDLib.getLDLibDir(), "assets/%s/compass/nodes".formatted(this.section.getSectionName().m_135827_()));
        if (!path.isDirectory()) {
            if (path.mkdirs()) {
                LDLib.LOGGER.info("Created directory %s".formatted(path));
            } else {
                LDLib.LOGGER.error("Failed to create directory %s".formatted(path));
                return;
            }
        }
        for (CompassNode removedNode : this.removedNodes) {
            file = new File(path, removedNode.getNodeName().m_135815_() + ".json");
            if (!file.exists() || file.delete()) continue;
            LDLib.LOGGER.error("Failed to delete file %s".formatted(file));
        }
        this.removedNodes.clear();
        for (CompassNode node : this.section.nodes.values()) {
            file = new File(path, node.getNodeName().m_135815_() + ".json");
            FileUtility.saveJson(file, (JsonElement)node.updateJson());
        }
        DialogWidget.showCheckBox(this.compassView, "ldlib.gui.compass.save_success", "ldlib.gui.compass.save_success.desc", shouldOpen -> {
            if (shouldOpen) {
                Util.m_137581_().m_137644_(path);
            }
        });
        CompassManager.INSTANCE.m_6213_(Minecraft.m_91087_().m_91098_());
    }

    protected void setEditMode(boolean editMode) {
        this.editMode = editMode;
        this.removedNodes.clear();
        this.editModeWidget.setVisible(editMode);
        this.editModeWidget.setActive(editMode);
    }

    protected void switchMode(Mode mode) {
        this.mode = mode;
        this.selectedNode = null;
        this.selectedLink = null;
    }

    protected void resetFitScale() {
        if (this.section.nodes.isEmpty()) {
            this.xOffset = 0.0f;
            this.yOffset = 0.0f;
            this.scale = 1.0f;
            return;
        }
        int minY = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (CompassNode node : this.section.nodes.values()) {
            Position position = node.getPosition();
            minX = Math.min(minX, position.x - node.size);
            minY = Math.min(minY, position.y - node.size);
            maxX = Math.max(maxX, position.x + node.size);
            maxY = Math.max(maxY, position.y + node.size);
        }
        this.xOffset = minX;
        this.yOffset = minY;
        float scaleWidth = (float)this.getSize().width / (float)(maxX - minX);
        float scaleHeight = (float)this.getSize().height / (float)(maxY - minY);
        this.scale = Math.min(scaleWidth, scaleHeight);
        if (this.scale < 0.5f) {
            this.scale = 0.5f;
        }
        this.xOffset -= ((float)this.getSize().width / this.scale - (float)(maxX - minX)) / 2.0f;
        this.yOffset -= ((float)this.getSize().height / this.scale - (float)(maxY - minY)) / 2.0f;
    }

    @Nullable
    protected TreeBuilder.Menu createMenu(double mouseX, double mouseY) {
        TreeBuilder.Menu menu = TreeBuilder.Menu.start().branch(Icons.GRID, "ldlib.gui.compass.grid_size", m -> m.leaf(this.gridWidth == 0 ? Icons.CHECK : IGuiTexture.EMPTY, "close", () -> {
            this.gridWidth = 0;
        }).leaf(this.gridWidth == 10 ? Icons.CHECK : IGuiTexture.EMPTY, "10\u00d710", () -> {
            this.gridWidth = 10;
        }).leaf(this.gridWidth == 25 ? Icons.CHECK : IGuiTexture.EMPTY, "25\u00d725", () -> {
            this.gridWidth = 25;
        }).leaf(this.gridWidth == 50 ? Icons.CHECK : IGuiTexture.EMPTY, "50\u00d750", () -> {
            this.gridWidth = 50;
        }).leaf(this.gridWidth == 100 ? Icons.CHECK : IGuiTexture.EMPTY, "100\u00d7100", () -> {
            this.gridWidth = 100;
        }).leaf(this.gridWidth == 150 ? Icons.CHECK : IGuiTexture.EMPTY, "150\u00d7150", () -> {
            this.gridWidth = 200;
        }));
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.CURSOR -> {
                menu.crossLine().leaf(Icons.ADD, "ldlib.gui.compass.add_node", () -> {
                    int newId = 0;
                    while (this.section.nodes.containsKey(new ResourceLocation("%s:%s/new_node_%d".formatted(this.section.sectionName.m_135827_(), this.section.sectionName.m_135815_(), newId)))) {
                        ++newId;
                    }
                    ResourceLocation id = new ResourceLocation("%s:%s/new_node_%d".formatted(this.section.sectionName.m_135827_(), this.section.sectionName.m_135815_(), newId));
                    DialogWidget.showStringEditorDialog(this.compassView, "ldlib.gui.compass.add_node", id.toString(), s -> ResourceLocation.m_135830_((String)s) && !this.section.nodes.containsKey(new ResourceLocation(s)), s -> {
                        if (s == null || !ResourceLocation.m_135830_((String)s) || this.section.nodes.containsKey(new ResourceLocation(s))) {
                            return;
                        }
                        int newMouseX = (int)((mouseX - (double)this.getPosition().x) / (double)this.scale + (double)this.xOffset);
                        int newMouseY = (int)((mouseY - (double)this.getPosition().y) / (double)this.scale + (double)this.yOffset);
                        JsonObject config = (JsonObject)LDLib.GSON.fromJson("{\n  \"section\": \"%s\",\n  \"button_texture\": {\n    \"type\": \"item\",\n    \"res\": \"minecraft:tnt\"\n  },\n  \"position\": [\n    %d,\n    %d\n  ],\n  \"page\": \"%s\",\n  \"items\": [\n  ]\n}\n".formatted(this.section.sectionName.toString(), newMouseX, newMouseY, s), JsonObject.class);
                        CompassNode node = new CompassNode(new ResourceLocation(s), config);
                        node.setSection(this.section);
                        this.section.nodes.put(node.getNodeName(), node);
                    });
                });
                if (this.selectedNode == null) {
                    yield menu;
                }
                menu.leaf(Icons.REMOVE, "ldlib.gui.compass.remove_node", () -> {
                    if (this.selectedNode != null) {
                        this.section.nodes.remove(this.selectedNode.getNodeName());
                        for (CompassNode node : this.section.nodes.values()) {
                            node.preNodes.remove(this.selectedNode);
                            node.childNodes.remove(this.selectedNode);
                        }
                        this.removedNodes.add(this.selectedNode);
                        this.selectedNode = null;
                    }
                }).leaf("ldlib.gui.editor.menu.rename", () -> {
                    if (this.selectedNode != null) {
                        DialogWidget.showStringEditorDialog(this.compassView, "ldlib.gui.editor.tips.rename", this.selectedNode.getNodeName().toString(), ResourceLocation::m_135830_, s -> {
                            if (s == null || !ResourceLocation.m_135830_((String)s)) {
                                return;
                            }
                            this.selectedNode.setNodeName(new ResourceLocation(s));
                        });
                    }
                }).branch("ldlib.gui.editor.group.size", m -> m.leaf(this.selectedNode.size == 20 ? Icons.CHECK : IGuiTexture.EMPTY, "20", () -> {
                    this.selectedNode.size = 20;
                }).leaf(this.selectedNode.size == 24 ? Icons.CHECK : IGuiTexture.EMPTY, "24", () -> {
                    this.selectedNode.size = 24;
                }).leaf(this.selectedNode.size == 30 ? Icons.CHECK : IGuiTexture.EMPTY, "30", () -> {
                    this.selectedNode.size = 30;
                }).leaf(this.selectedNode.size == 40 ? Icons.CHECK : IGuiTexture.EMPTY, "40", () -> {
                    this.selectedNode.size = 40;
                }).leaf(this.selectedNode.size == 60 ? Icons.CHECK : IGuiTexture.EMPTY, "60", () -> {
                    this.selectedNode.size = 60;
                }).leaf(this.selectedNode.size == 80 ? Icons.CHECK : IGuiTexture.EMPTY, "80", () -> {
                    this.selectedNode.size = 80;
                }).leaf(this.selectedNode.size == 100 ? Icons.CHECK : IGuiTexture.EMPTY, "100", () -> {
                    this.selectedNode.size = 100;
                }).leaf(this.selectedNode.size == 150 ? Icons.CHECK : IGuiTexture.EMPTY, "150", () -> {
                    this.selectedNode.size = 150;
                })).branch("ldlib.gui.compass.attach_items", m -> {
                    m.branch(Icons.ADD, "ldlib.gui.editor.tips.add_item", m2 -> m2.leaf("ldlib.gui.compass.attach_items.item", () -> DialogWidget.showItemSelector(this.compassView, "ldlib.gui.editor.tips.add_item", ItemStack.f_41583_, item -> {
                        if (item != null && item != Items.f_41852_) {
                            JsonArray items = GsonHelper.m_13832_((JsonObject)this.selectedNode.config, (String)"items", (JsonArray)new JsonArray());
                            items.add(BuiltInRegistries.f_257033_.m_7981_(item).toString());
                            this.selectedNode.config.add("items", (JsonElement)items);
                        }
                    })).leaf("ldlib.gui.compass.attach_items.tag", () -> DialogWidget.showStringEditorDialog(this.compassView, "ldlib.gui.compass.attach_items.tag", "minecraft:planks", ResourceLocation::m_135830_, s -> {
                        if (s == null || !ResourceLocation.m_135830_((String)s)) {
                            return;
                        }
                        JsonArray items = GsonHelper.m_13832_((JsonObject)this.selectedNode.config, (String)"items", (JsonArray)new JsonArray());
                        items.add("#" + s);
                        this.selectedNode.config.add("items", (JsonElement)items);
                    })));
                    JsonArray items = GsonHelper.m_13832_((JsonObject)this.selectedNode.config, (String)"items", (JsonArray)new JsonArray());
                    if (!items.isEmpty()) {
                        m.crossLine();
                        for (JsonElement element : items) {
                            String data = element.getAsString();
                            if (ResourceLocation.m_135830_((String)data)) {
                                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(data));
                                if (item == Items.f_41852_) continue;
                                m.leaf(new ItemStackTexture(item), LocalizationUtils.format("ldlib.gui.editor.tips.remove_item", new Object[0]) + ": " + LocalizationUtils.format(item.m_5524_(), new Object[0]), () -> items.remove(element));
                                continue;
                            }
                            if (!data.startsWith("#") || !ResourceLocation.m_135830_((String)data.substring(1))) continue;
                            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(data.substring(1)));
                            Optional tagCollection = BuiltInRegistries.f_257033_.m_203431_(tag);
                            tagCollection.ifPresent(named -> {
                                ArrayList itemList = new ArrayList();
                                named.forEach(holder -> itemList.add((Item)holder.m_203334_()));
                                m.leaf(new ItemStackTexture((ItemStack[])itemList.stream().map(ItemStack::new).toArray(ItemStack[]::new)), LocalizationUtils.format("ldlib.gui.editor.tips.remove_tag", new Object[0]) + ": " + data, () -> items.remove(element));
                            });
                        }
                    }
                }).leaf(Icons.EDIT_FILE, "ldlib.gui.editor.menu.edit", () -> {
                    File file = new File(LDLib.getLDLibDir(), "assets/%s/compass/pages/en_us/%s.xml".formatted(this.selectedNode.getNodeName().m_135827_(), this.selectedNode.getNodeName().m_135815_()));
                    if (!file.exists()) {
                        String content;
                        if (!file.getParentFile().isDirectory()) {
                            file.getParentFile().mkdirs();
                        }
                        ResourceLocation pageLocation = this.selectedNode.getPage();
                        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
                        String path = "compass/pages/en_us/%s.xml".formatted(pageLocation.m_135815_());
                        Optional option = resourceManager.m_213713_(new ResourceLocation(pageLocation.m_135827_(), path));
                        Resource resource = option.orElseGet(() -> (Resource)resourceManager.m_213713_(LDLib.location("compass/pages/en_us/missing.xml")).orElseThrow());
                        try (InputStream inputStream = resource.m_215507_();){
                            content = FileUtility.readInputStream(inputStream);
                        }
                        catch (Exception e) {
                            content = "<page>\n    <h1>Page Title</h1>\n    <text>\n        Page Content\n    </text>\n</page>\n";
                        }
                        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                            writer.write(content);
                        }
                        catch (Exception ignored) {
                            LDLib.LOGGER.error("Failed to create file %s".formatted(file));
                            return;
                        }
                    }
                    Util.m_137581_().m_137644_(file);
                });
                this.createTextureMenu(menu, "ldlib.gui.compass.set_button_texture", this.selectedNode.getButtonTexture(), new ItemStackTexture(Items.f_41996_), texture -> this.selectedNode.setButtonTexture((IGuiTexture)texture));
                this.createTextureMenu(menu, "ldlib.gui.compass.set_background", Optional.ofNullable(this.selectedNode.getBackground()).orElse(this.compassView.config.getNodeBackground()), this.compassView.config.getNodeBackground(), texture -> this.selectedNode.setBackground(texture == this.compassView.config.getNodeBackground() ? null : texture));
                this.createTextureMenu(menu, "ldlib.gui.compass.set_hover_background", Optional.ofNullable(this.selectedNode.getHoverBackground()).orElse(this.compassView.config.getNodeHoverBackground()), this.compassView.config.getNodeHoverBackground(), texture -> this.selectedNode.setHoverBackground(texture == this.compassView.config.getNodeHoverBackground() ? null : texture));
                yield menu;
            }
            case Mode.MOVE -> menu.crossLine().leaf(this.magnetic ? Icons.CHECK : IGuiTexture.EMPTY, "ldlib.gui.compass.magnetic", () -> {
                this.magnetic = !this.magnetic;
            });
            case Mode.LINK -> this.selectedLink == null ? menu : menu.crossLine().leaf(Icons.REMOVE, "ldlib.gui.editor.menu.remove", () -> {
                if (this.selectedLink != null) {
                    ((CompassNode)this.selectedLink.left()).childNodes.remove(this.selectedLink.right());
                    ((CompassNode)this.selectedLink.right()).preNodes.remove(this.selectedLink.left());
                    ((CompassNode)this.selectedLink.left()).preNodes.remove(this.selectedLink.right());
                    ((CompassNode)this.selectedLink.right()).childNodes.remove(this.selectedLink.left());
                    this.selectedLink = null;
                }
            });
        };
    }

    protected void createTextureMenu(TreeBuilder.Menu menu, String title, IGuiTexture initial, IGuiTexture defaultTexture, Consumer<IGuiTexture> consumer) {
        menu.branch(initial, title, m -> m.leaf(defaultTexture == initial ? defaultTexture : IGuiTexture.EMPTY, "ldlib.gui.compass.default", () -> consumer.accept(defaultTexture)).leaf(defaultTexture != initial && initial instanceof ResourceTexture ? initial : IGuiTexture.EMPTY, "ldlib.gui.editor.register.texture.resource_texture", () -> DialogWidget.showStringEditorDialog(this.compassView, title, "ldlib:textures/gui/icon.png", ResourceLocation::m_135830_, s -> {
            if (s != null && ResourceLocation.m_135830_((String)s)) {
                consumer.accept(new ResourceTexture((String)s));
            }
        })).leaf(defaultTexture != initial && initial instanceof ItemStackTexture ? initial : IGuiTexture.EMPTY, "ldlib.gui.editor.register.texture.item_texture", () -> DialogWidget.showItemSelector(this.compassView, title, ItemStack.f_41583_, item -> {
            if (item != null && item != Items.f_41852_) {
                consumer.accept(new ItemStackTexture((Item)item));
            }
        })).leaf(defaultTexture != initial && initial instanceof ShaderTexture ? initial : IGuiTexture.EMPTY, "ldlib.gui.editor.register.texture.shader_texture", () -> DialogWidget.showStringEditorDialog(this.compassView, title, "ldlib:compass_node", ResourceLocation::m_135830_, s -> {
            if (s != null && ResourceLocation.m_135830_((String)s)) {
                consumer.accept(ShaderTexture.createShader(new ResourceLocation(s)));
            }
        })));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (this.isMouseOverElement(mouseX, mouseY)) {
            TreeBuilder.Menu menu;
            if (button == 0) {
                int newMouseX = (int)((mouseX - (double)this.getPosition().x) / (double)this.scale + (double)this.xOffset);
                int newMouseY = (int)((mouseY - (double)this.getPosition().y) / (double)this.scale + (double)this.yOffset);
                if (this.editMode) {
                    block5: for (CompassNode node : this.section.nodes.values()) {
                        if (!this.isNodeOver(node, newMouseX, newMouseY)) continue;
                        switch (this.mode) {
                            case CURSOR: {
                                this.selectedNode = node;
                                continue block5;
                            }
                            case MOVE: {
                                this.selectedNode = node;
                                this.originPosition = node.getPosition();
                                break;
                            }
                            case LINK: {
                                this.selectedNode = node;
                            }
                        }
                        return true;
                    }
                    if (this.mode == Mode.LINK) {
                        for (CompassNode node : this.section.nodes.values()) {
                            for (CompassNode preNode : node.preNodes) {
                                float dist;
                                Vector2f vec = new Vector2f((float)(node.getPosition().x - preNode.getPosition().x), (float)(node.getPosition().y - preNode.getPosition().y));
                                Vector2f mid = new Vector2f((float)(node.getPosition().x + preNode.getPosition().x) / 2.0f, (float)(node.getPosition().y + preNode.getPosition().y) / 2.0f);
                                Vector2f mouseVec = new Vector2f((float)newMouseX, (float)newMouseY).sub((Vector2fc)mid);
                                Vector2f project = new Vector2f(0.0f, 0.0f);
                                float l = vec.lengthSquared();
                                if ((double)l != 0.0) {
                                    project.set((Vector2fc)vec).mul(mouseVec.dot((Vector2fc)vec) / l);
                                }
                                if (!(project.lengthSquared() < vec.lengthSquared() / 4.0f) || !((dist = project.sub((Vector2fc)mouseVec).length()) < 10.0f)) continue;
                                this.selectedLink = Pair.of((Object)preNode, (Object)node);
                                return true;
                            }
                        }
                    }
                }
                this.isDragging = true;
            } else if (button == 1 && this.editMode && (menu = this.createMenu(mouseX, mouseY)) != null) {
                this.compassView.waitToAdded(new MenuWidget((int)mouseX, (int)mouseY, 14, menu.build()).setNodeTexture(MenuWidget.NODE_TEXTURE).setLeafTexture(MenuWidget.LEAF_TEXTURE).setNodeHoverTexture(MenuWidget.NODE_HOVER_TEXTURE).setCrossLinePredicate(TreeBuilder.Menu::isCrossLine).setKeyIconSupplier(TreeBuilder.Menu::getIcon).setKeyNameSupplier(TreeBuilder.Menu::getName).setOnNodeClicked(TreeBuilder.Menu::handle).setBackground(MenuWidget.BACKGROUND));
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        block3: {
            int newMouseY;
            int newMouseX;
            block4: {
                CompassNode lastSelectedNode = this.selectedNode;
                this.isDragging = false;
                if (!this.editMode || this.mode != Mode.CURSOR) {
                    this.selectedNode = null;
                }
                if (!this.isMouseOverElement(mouseX, mouseY)) break block3;
                newMouseX = (int)((mouseX - (double)this.getPosition().x) / (double)this.scale + (double)this.xOffset);
                newMouseY = (int)((mouseY - (double)this.getPosition().y) / (double)this.scale + (double)this.yOffset);
                if (!this.editMode) break block4;
                if (this.mode != Mode.LINK || lastSelectedNode == null) break block3;
                for (CompassNode node : this.section.nodes.values()) {
                    if (lastSelectedNode == node || !this.isNodeOver(node, newMouseX, newMouseY)) continue;
                    node.preNodes.add(lastSelectedNode);
                    lastSelectedNode.childNodes.add(node);
                    return true;
                }
                break block3;
            }
            for (CompassNode node : this.section.nodes.values()) {
                if (!this.isNodeOver(node, newMouseX, newMouseY)) continue;
                this.compassView.openNodeContent(node);
                return true;
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            this.xOffset += (float)(this.lastMouseX - mouseX) / this.scale;
            this.yOffset += (float)(this.lastMouseY - mouseY) / this.scale;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
        if (this.selectedNode != null && this.editMode && this.mode == Mode.MOVE) {
            int x = this.originPosition.x + (int)((mouseX - this.lastMouseX) / (double)this.scale);
            int y = this.originPosition.y + (int)((mouseY - this.lastMouseY) / (double)this.scale);
            if (this.magnetic && !CompassSectionWidget.isShiftDown()) {
                x -= x % 10;
                y -= y % 10;
            }
            this.selectedNode.setPosition(new Position(x, y));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        float newScale;
        if (this.isMouseOverElement(mouseX, mouseY) && (newScale = (float)Mth.m_14008_((double)((double)this.scale + wheelDelta * (double)0.1f), (double)0.1f, (double)10.0)) != this.scale) {
            this.xOffset += (float)(mouseX - (double)this.getPosition().x) / this.scale - (float)(mouseX - (double)this.getPosition().x) / newScale;
            this.yOffset += (float)(mouseY - (double)this.getPosition().y) / this.scale - (float)(mouseY - (double)this.getPosition().y) / newScale;
            this.scale = newScale;
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            int newMouseX = (int)((float)(mouseX - this.getPosition().x) / this.scale + this.xOffset);
            int newMouseY = (int)((float)(mouseY - this.getPosition().y) / this.scale + this.yOffset);
            for (CompassNode node : this.section.nodes.values()) {
                if (!this.isNodeOver(node, newMouseX, newMouseY)) continue;
                this.gui.getModularUIGui().setHoverTooltip(List.of(node.getChatComponent()), ItemStack.f_41583_, null, null);
            }
        }
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
    }

    protected boolean isNodeOver(CompassNode node, int newMouseX, int newMouseY) {
        return CompassSectionWidget.isMouseOver(node.getPosition().x - node.size / 2, node.getPosition().y - node.size / 2, node.size, node.size, newMouseX, newMouseY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.setBackground(this.section.getBackgroundTexture() == null ? this.compassView.config.getSectionBackground() : this.section.getBackgroundTexture());
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
        Position pos = this.getPosition();
        Size size = this.getSize();
        Matrix4f trans = graphics.m_280168_().m_85850_().m_252922_();
        Vector4f realPos = trans.transform(new Vector4f((float)pos.x, (float)pos.y, 0.0f, 1.0f));
        Vector4f realPos2 = trans.transform(new Vector4f((float)(pos.x + size.width), (float)(pos.y + size.height), 0.0f, 1.0f));
        graphics.m_280588_((int)realPos.x, (int)realPos.y, (int)realPos2.x, (int)realPos2.y);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.getPosition().x, (float)this.getPosition().y, 0.0f);
        graphics.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
        graphics.m_280168_().m_252880_(-this.xOffset, -this.yOffset, 0.0f);
        int newMouseX = (int)((float)(mouseX - this.getPosition().x) / this.scale + this.xOffset);
        int newMouseY = (int)((float)(mouseY - this.getPosition().y) / this.scale + this.yOffset);
        if (this.editMode && this.gridWidth > 0) {
            graphics.m_286007_(() -> {
                float w = (float)size.width / this.scale;
                float h = (float)size.height / this.scale;
                int sx = (int)((float)pos.x / this.scale + this.xOffset - w - this.xOffset % (float)this.gridWidth);
                int sy = (int)((float)pos.y / this.scale + this.yOffset - h - this.yOffset % (float)this.gridWidth);
                sx -= sx % this.gridWidth;
                sy -= sy % this.gridWidth;
                int x = sx;
                while ((float)x < (float)sx + 3.0f * w) {
                    int y = sy;
                    while ((float)y < (float)sy + 3.0f * h) {
                        DrawerHelper.drawSolidRect(graphics, x, sy, 1, (int)(3.0f * h), ColorPattern.T_GRAY.color);
                        DrawerHelper.drawSolidRect(graphics, sx, y, (int)(3.0f * w), 1, ColorPattern.T_GRAY.color);
                        y += this.gridWidth;
                    }
                    x += this.gridWidth;
                }
            });
        }
        for (CompassNode node : this.section.nodes.values()) {
            this.drawChildLines(graphics, node);
        }
        if (this.editMode && this.mode == Mode.LINK && this.selectedNode != null) {
            DrawerHelper.drawLines(graphics, List.of(new Vec2((float)this.selectedNode.getPosition().x, (float)this.selectedNode.getPosition().y), new Vec2((float)newMouseX, (float)newMouseY)), ColorPattern.T_GREEN.color, ColorPattern.T_GREEN.color, 1.0f);
        }
        for (CompassNode node : this.section.nodes.values()) {
            this.drawNode(graphics, newMouseX, newMouseY, node);
        }
        graphics.m_280168_().m_85849_();
        graphics.m_280618_();
        this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawNode(GuiGraphics graphics, int mouseX, int mouseY, CompassNode node) {
        boolean isHover;
        Position nodePosition = node.getPosition();
        boolean bl = isHover = this.isNodeOver(node, mouseX, mouseY) || node == this.selectedNode;
        IGuiTexture texture = isHover ? (node.getHoverBackground() == null ? this.compassView.config.getNodeHoverBackground() : node.getHoverBackground()) : (node.getBackground() == null ? this.compassView.config.getNodeBackground() : node.getBackground());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        texture.draw(graphics, mouseX, mouseY, (float)nodePosition.x - (float)node.size / 2.0f, (float)nodePosition.y - (float)node.size / 2.0f, node.size, node.size);
        node.getButtonTexture().draw(graphics, mouseX, mouseY, (float)nodePosition.x - (float)node.size * 8.0f / 24.0f, (float)nodePosition.y - (float)node.size * 8.0f / 24.0f, node.size * 16 / 24, node.size * 16 / 24);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawChildLines(GuiGraphics graphics, CompassNode node) {
        for (CompassNode childNode : node.getChildNodes()) {
            if (childNode.section != node.section) continue;
            Vec2 from = new Vec2((float)node.getPosition().x, (float)node.getPosition().y);
            Vec2 to = new Vec2((float)childNode.getPosition().x, (float)childNode.getPosition().y);
            float time = (float)Math.abs((System.currentTimeMillis() + (long)(node.hashCode() % 24000) + (long)(childNode.hashCode() % 24000)) % 2400000L) / 500.0f;
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(Shaders::getCompassLineShader);
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85819_);
            RenderSystem.getShader().m_173356_("iTime").m_5985_(time + (float)(childNode.hashCode() % 4000) / 1000.0f);
            if (this.editMode && this.mode == Mode.LINK && this.selectedLink != null && (this.selectedLink.left() == node && this.selectedLink.right() == childNode || this.selectedLink.left() == childNode && this.selectedLink.right() == node)) {
                RenderBufferUtils.drawColorTexLines(graphics.m_280168_(), (VertexConsumer)bufferbuilder, List.of(from, to), ColorPattern.RED.color, ColorPattern.RED.color, 16.0f);
            } else {
                RenderBufferUtils.drawColorTexLines(graphics.m_280168_(), (VertexConsumer)bufferbuilder, List.of(from, to), -11021410, -12303190, 16.0f);
            }
            tesselator.m_85914_();
            RenderSystem.defaultBlendFunc();
        }
    }

    protected static enum Mode {
        CURSOR(Icons.CURSOR),
        MOVE(Icons.MOVE),
        LINK(Icons.LINK);

        final IGuiTexture icon;

        private Mode(IGuiTexture icon) {
            this.icon = icon;
        }
    }
}

