/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component.animation;

import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.Action;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.AnimationFrame;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.CompassScene;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.TooltipBGTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.ShaderTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.w3c.dom.Element;

public class InformationAction
extends Action {
    private final IGuiTexture guiTexture;
    private final List<Component> text = new ArrayList<Component>();

    public InformationAction(IGuiTexture guiTexture, List<Component> text) {
        this.guiTexture = guiTexture;
        this.text.addAll(text);
    }

    public InformationAction(Element element) {
        super(element);
        float u0 = XmlUtils.getAsFloat(element, "u0", 0.0f);
        float v0 = XmlUtils.getAsFloat(element, "v0", 0.0f);
        float u1 = XmlUtils.getAsFloat(element, "u1", 1.0f);
        float v1 = XmlUtils.getAsFloat(element, "v1", 1.0f);
        String type = XmlUtils.getAsString(element, "type", "");
        String url = XmlUtils.getAsString(element, "url", "");
        this.guiTexture = switch (type) {
            case "resource" -> new ResourceTexture(url).getSubTexture(u0, v0, u1, v1);
            case "item" -> new ItemStackTexture((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(url)));
            case "shader" -> ShaderTexture.createShader(new ResourceLocation(url));
            default -> IGuiTexture.EMPTY;
        };
        this.text.addAll(XmlUtils.getComponents(element, Style.f_131099_));
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public void performAction(AnimationFrame frame, CompassScene scene, boolean anima) {
        int size = Math.min(scene.getHeaderGroup().getSize().width, scene.getHeaderGroup().getSize().height);
        if (this.text.isEmpty() && this.guiTexture == IGuiTexture.EMPTY) {
            return;
        }
        if (this.text.isEmpty()) {
            scene.addInformation(new ImageWidget(0, 0, size, size, this.guiTexture), anima);
        } else if (this.guiTexture == IGuiTexture.EMPTY) {
            ComponentPanelWidget componentPanelWidget = new ComponentPanelWidget(0, 0, this.text).clickHandler(CompassManager::onComponentClick);
            componentPanelWidget.setBackground(TooltipBGTexture.INSTANCE);
            int maxWidth = 0;
            while (maxWidth < scene.getHeaderGroup().getSize().width && (componentPanelWidget.getSize().height == 0 || componentPanelWidget.getSize().height > size)) {
                componentPanelWidget.setMaxWidthLimit(maxWidth += 50);
            }
            scene.addInformation(componentPanelWidget, anima);
        } else {
            ComponentPanelWidget componentPanelWidget = new ComponentPanelWidget(0, 0, this.text).clickHandler(CompassManager::onComponentClick);
            componentPanelWidget.setBackground(TooltipBGTexture.INSTANCE);
            int maxWidth = 0;
            while (maxWidth < scene.getHeaderGroup().getSize().width && (componentPanelWidget.getSize().height == 0 || componentPanelWidget.getSize().height > size)) {
                componentPanelWidget.setMaxWidthLimit(maxWidth += 50);
            }
            WidgetGroup container = new WidgetGroup(0, 0, size + maxWidth, size);
            container.addWidget(new ImageWidget(2, 2, size - 4, size - 4, this.guiTexture));
            componentPanelWidget.addSelfPosition(size, (size - componentPanelWidget.getSize().height) / 2);
            container.addWidget(componentPanelWidget);
            scene.addInformation(container, anima);
        }
    }
}

