/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Function;

public class WrapperConfigurator
extends Configurator {
    public final Widget inner;
    public boolean removeTitleBar;

    public WrapperConfigurator(Widget widget) {
        this("", widget, true);
    }

    public WrapperConfigurator(Function<WrapperConfigurator, Widget> widgetSupplier) {
        this("", widgetSupplier, true);
    }

    public WrapperConfigurator(String name, Widget widget) {
        this(name, widget, false);
    }

    public WrapperConfigurator(String name, Function<WrapperConfigurator, Widget> widgetSupplier) {
        this(name, widgetSupplier, false);
    }

    public WrapperConfigurator(String name, Widget widget, boolean removeTitleBar) {
        this(name, (WrapperConfigurator configurator) -> widget, removeTitleBar);
    }

    public WrapperConfigurator(String name, Function<WrapperConfigurator, Widget> widgetSupplier, boolean removeTitleBar) {
        super(name);
        this.inner = widgetSupplier.apply(this);
        this.removeTitleBar = removeTitleBar;
    }

    @Override
    public void computeHeight() {
        super.computeHeight();
        if (this.removeTitleBar) {
            this.setSize(new Size(this.getSize().width, this.inner.getSize().height + 4));
        } else {
            this.setSize(new Size(this.getSize().width, this.inner.getSize().height + 19));
        }
    }

    @Override
    public void init(int width) {
        super.init(width);
        Size size = this.inner.getSize();
        this.inner.setSelfPosition(new Position((width - size.width) / 2, this.removeTitleBar ? 2 : 17));
        this.addWidget(this.inner);
    }

    public WrapperConfigurator setRemoveTitleBar(boolean removeTitleBar) {
        this.removeTitleBar = removeTitleBar;
        return this;
    }
}

