/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject;

import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Transform;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.IScene;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public interface ISceneObject {
    default public UUID id() {
        return this.transform().id();
    }

    public Transform transform();

    default public void setTransform(Transform transform) {
        transform.set(transform);
    }

    @Nullable
    public IScene getScene();

    public void setSceneInternal(IScene var1);

    default public void setScene(IScene scene) {
        if (this.getScene() != scene) {
            this.setSceneInternal(scene);
            this.children().forEach(child -> child.setScene(scene));
        }
    }

    default public void destroy() {
        this.transform().parent(null);
        Optional.ofNullable(this.getScene()).ifPresent(scene -> scene.removeSceneObjectInternal(this));
        this.children().forEach(ISceneObject::destroy);
    }

    default public List<ISceneObject> children() {
        return this.transform().children().stream().map(Transform::sceneObject).toList();
    }

    default public void onTransformChanged() {
    }

    default public void onChildChanged() {
    }

    default public void onParentChanged() {
    }

    default public void updateTick() {
    }

    default public void updateFrame(float partialTicks) {
    }

    default public void executeAll(Consumer<ISceneObject> consumer) {
        consumer.accept(this);
        this.children().forEach(child -> child.executeAll(consumer));
    }

    default public void executeAll(Consumer<ISceneObject> consumer, @Nullable Consumer<ISceneObject> before, @Nullable Consumer<ISceneObject> after) {
        if (before != null) {
            before.accept(this);
        }
        consumer.accept(this);
        this.children().forEach(child -> child.executeAll(consumer));
        if (after != null) {
            after.accept(this);
        }
    }

    default public void awake() {
        this.transform().awake();
    }
}

