/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.view;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.List;

@LDLRegister(name="history", group="editor")
public class HistoryView
extends FloatViewWidget {
    private WidgetGroup container;

    public HistoryView() {
        super(100, 100, 180, 120, false);
    }

    @Override
    public IGuiTexture getIcon() {
        return Icons.HISTORY.copy();
    }

    @Override
    public void initWidget() {
        super.initWidget();
        this.container = new WidgetGroup(0, 0, this.content.getSizeWidth() - 2, 0);
        this.content.addWidget(new DraggableScrollableWidgetGroup(0, 0, this.content.getSizeWidth(), this.content.getSizeHeight()).setYScrollBarWidth(2).setYBarStyle(null, ColorPattern.T_WHITE.rectTexture().setRadius(1.0f).transform(-0.5f, 0.0f)).addWidget(this.container));
        this.loadList();
    }

    public void loadList() {
        this.container.clearAllWidgets();
        int width = this.container.getSizeWidth();
        List<Editor.HistoryItem> history = this.editor.getHistory();
        for (Editor.HistoryItem historyItem : history) {
            WidgetGroup group = new WidgetGroup(0, this.container.widgets.size() * 10, width, 10);
            group.addWidget(new ButtonWidget(0, 0, width, 10, IGuiTexture.EMPTY, cd -> {
                this.editor.jumpToHistory(historyItem);
                if (!this.editor.getFloatView().widgets.contains(this)) {
                    this.editor.getFloatView().addWidget(this);
                }
                this.loadList();
            }).setHoverBorderTexture(-1, -1));
            group.addWidget(new TextTextureWidget(3, 0, width - 3, 10, historyItem.name()).textureStyle(t -> t.setType(TextTexture.TextType.LEFT_ROLL)));
            group.addWidget(new ImageWidget(0, 0, width, 10, () -> this.editor.getCurrentHistory() == historyItem ? ColorPattern.T_WHITE.rectTexture() : IGuiTexture.EMPTY));
            this.container.addWidget(group);
        }
        this.container.setSizeHeight(10 * history.size());
    }

    public WidgetGroup getContainer() {
        return this.container;
    }
}

