/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.factory;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.core.mixins.accessor.ServerPlayerAccessor;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.networking.LDLNetworking;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketUIOpen;
import com.lowdragmc.lowdraglib.side.ForgeEventHooks;
import dev.latvian.mods.rhino.util.HideFromJS;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class UIFactory<T> {
    public final ResourceLocation uiFactoryId;
    public static final Map<ResourceLocation, UIFactory<?>> FACTORIES = new HashMap();

    public UIFactory(ResourceLocation uiFactoryId) {
        this.uiFactoryId = uiFactoryId;
    }

    public static void register(UIFactory<?> factory) {
        FACTORIES.put(factory.uiFactoryId, factory);
    }

    @HideFromJS
    public final boolean openUI(T holder, ServerPlayer player) {
        ModularUI uiTemplate = this.createUITemplate(holder, (Player)player);
        if (uiTemplate == null) {
            return false;
        }
        uiTemplate.initWidgets();
        if (player.f_36096_ != player.f_36095_) {
            player.m_6915_();
        }
        ((ServerPlayerAccessor)player).callNextContainerCounter();
        int currentWindowId = ((ServerPlayerAccessor)player).getContainerCounter();
        FriendlyByteBuf serializedHolder = new FriendlyByteBuf(Unpooled.buffer());
        this.writeHolderToSyncData(serializedHolder, holder);
        ModularUIContainer container = new ModularUIContainer(uiTemplate, currentWindowId);
        uiTemplate.mainGroup.writeInitialData(serializedHolder);
        LDLNetworking.NETWORK.sendToPlayer(new SPacketUIOpen(this.uiFactoryId, serializedHolder, currentWindowId), player);
        ((ServerPlayerAccessor)player).callInitMenu(container);
        player.f_36096_ = container;
        if (Platform.isForge()) {
            ForgeEventHooks.postPlayerContainerEvent((Player)player, container);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void initClientUI(FriendlyByteBuf serializedHolder, int windowId) {
        T holder = this.readHolderFromSyncData(serializedHolder);
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer entityPlayer = minecraft.f_91074_;
        ModularUI uiTemplate = this.createUITemplate(holder, (Player)entityPlayer);
        if (uiTemplate == null) {
            return;
        }
        uiTemplate.initWidgets();
        ModularUIGuiContainer ModularUIGuiContainer2 = new ModularUIGuiContainer(uiTemplate, windowId);
        uiTemplate.mainGroup.readInitialData(serializedHolder);
        minecraft.m_91152_((Screen)ModularUIGuiContainer2);
        minecraft.f_91074_.f_36096_ = ModularUIGuiContainer2.m_6262_();
    }

    protected abstract ModularUI createUITemplate(T var1, Player var2);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract T readHolderFromSyncData(FriendlyByteBuf var1);

    protected abstract void writeHolderToSyncData(FriendlyByteBuf var1, T var2);
}

