/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.LinearTriggerNode;
import java.util.List;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

@LDLRegister(name="compound writer", group="graph_processor.node.minecraft.data")
public class CompoundWriterNode
extends LinearTriggerNode {
    @InputPort
    public CompoundTag tag;
    @InputPort
    public String key;
    @InputPort
    public Object value;
    @OutputPort
    public CompoundTag out;
    @Configurable(name="key")
    public String internalKey = "";

    @Override
    public void process() {
        if (this.tag == null) {
            return;
        }
        this.out = this.tag.m_6426_();
        String realKey = this.key;
        if (realKey == null) {
            realKey = this.internalKey;
        }
        if (this.value instanceof String) {
            this.out.m_128359_(realKey, (String)this.value);
        } else {
            Object object = this.value;
            if (object instanceof Number) {
                Number number = (Number)object;
                this.out.m_128350_(realKey, number.floatValue());
            } else if (this.value instanceof Boolean) {
                this.out.m_128379_(realKey, ((Boolean)this.value).booleanValue());
            } else if (this.value instanceof CompoundTag) {
                this.out.m_128365_(realKey, (Tag)((CompoundTag)this.value));
            } else {
                object = this.value;
                if (object instanceof List) {
                    List list = (List)object;
                    ListTag listTag = new ListTag();
                    this.dfsList(listTag, list);
                    this.out.m_128365_(realKey, (Tag)listTag);
                }
            }
        }
    }

    public void dfsList(ListTag listTag, List<?> list) {
        for (Object element : list) {
            if (element instanceof String) {
                listTag.add((Object)StringTag.m_129297_((String)((String)element)));
                continue;
            }
            if (element instanceof Number) {
                Number number = (Number)element;
                listTag.add((Object)FloatTag.m_128566_((float)number.floatValue()));
                continue;
            }
            if (element instanceof Boolean) {
                Boolean v = (Boolean)element;
                listTag.add((Object)ByteTag.m_128273_((boolean)v));
                continue;
            }
            if (element instanceof CompoundTag) {
                listTag.add((Object)((CompoundTag)element));
                continue;
            }
            if (!(element instanceof List)) continue;
            List subList = (List)element;
            ListTag subListTag = new ListTag();
            this.dfsList(subListTag, subList);
            listTag.add((Object)subListTag);
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("key") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

