/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget.codeeditor;

import com.lowdragmc.lowdraglib.gui.widget.codeeditor.Cursor;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.Document;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.Selection;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.StyledLine;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.StyledText;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.FoldingManager;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.ILanguageDefinition;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.StyleManager;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.SyntaxParser;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.Token;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class CodeEditor {
    private String indentString = "    ";
    private final Document document = new Document();
    private final SyntaxParser syntaxParser = new SyntaxParser();
    private final StyleManager styleManager;
    private Cursor cursor = new Cursor(0, 0);
    private final FoldingManager foldingManager;
    private final List<StyledLine> styledLines = new ArrayList<StyledLine>();
    @Nullable
    private Selection selection;
    private List<StyledLine> visibleLinesCache;

    public CodeEditor() {
        this.styleManager = new StyleManager();
        this.foldingManager = new FoldingManager();
        this.reparseAndStyle();
    }

    public void setLanguageDefinition(ILanguageDefinition languageDefinition) {
        if (languageDefinition != this.syntaxParser.getLanguageDefinition()) {
            this.syntaxParser.setLanguageDefinition(languageDefinition);
            this.reparseAndStyle();
        }
    }

    public void setCursor(int line, int column) {
        this.setCursor(new Cursor(line, column));
    }

    public void setCursorLine(int line) {
        this.setCursor(new Cursor(line, this.cursor.column()));
    }

    public void setCursorColumn(int column) {
        this.setCursor(new Cursor(this.cursor.line(), column));
    }

    public void insertText(String text) {
        String[] lines;
        if (this.isSelectionValid()) {
            this.deleteSelection();
        }
        if ((lines = text.split("\n", -1)).length == 1) {
            this.document.insertText(this.cursor.line(), this.cursor.column(), text);
            this.setCursorColumn(this.cursor.column() + text.length());
        } else {
            String currentLine = this.document.getLine(this.cursor.line());
            String beforeCursor = currentLine.substring(0, this.cursor.column());
            String afterCursor = currentLine.substring(this.cursor.column());
            this.document.setLine(this.cursor.line(), beforeCursor + lines[0]);
            for (int i = 1; i < lines.length - 1; ++i) {
                this.document.insertLine(this.cursor.line() + i, lines[i]);
            }
            int lastLineIndex = this.cursor.line() + lines.length - 1;
            this.document.insertLine(lastLineIndex, lines[lines.length - 1] + afterCursor);
            this.setCursorLine(lastLineIndex);
            this.setCursorColumn(lines[lines.length - 1].length());
        }
        this.reparseAndStyle();
    }

    public void deleteText() {
        if (this.isSelectionValid()) {
            this.deleteSelection();
        } else if (this.cursor.column() > 0) {
            this.document.deleteText(this.cursor.line(), this.cursor.column() - 1, 1);
            this.setCursorColumn(this.cursor.column() - 1);
            this.reparseAndStyle();
        } else if (this.cursor.line() > 0) {
            int previousLineLength = this.document.getLine(this.cursor.line() - 1).length();
            String currentLineText = this.document.getLine(this.cursor.line());
            this.document.deleteLine(this.cursor.line());
            this.setCursorLine(this.cursor.line() - 1);
            this.setCursorColumn(previousLineLength);
            this.document.setLine(this.cursor.line(), this.document.getLine(this.cursor.line()) + currentLineText);
            this.reparseAndStyle();
        }
    }

    public void backspace() {
        if (this.isSelectionValid()) {
            this.deleteSelection();
        } else {
            String currentLine = this.document.getLine(this.cursor.line());
            if (this.cursor.column() > 0) {
                int col = this.cursor.column();
                String beforeCursor = currentLine.substring(0, col);
                if (this.isInIndentation(beforeCursor)) {
                    int indentSize = this.getIndentSize(beforeCursor);
                    int newCol = Math.max(0, col - indentSize);
                    this.document.setLine(this.cursor.line(), beforeCursor.substring(0, newCol) + currentLine.substring(col));
                    this.setCursorColumn(newCol);
                } else {
                    this.document.setLine(this.cursor.line(), beforeCursor.substring(0, col - 1) + currentLine.substring(col));
                    this.setCursorColumn(col - 1);
                }
            } else if (this.cursor.line() > 0) {
                String previousLine = this.document.getLine(this.cursor.line() - 1);
                String currentLineText = this.document.getLine(this.cursor.line());
                this.document.setLine(this.cursor.line() - 1, previousLine + currentLineText);
                this.document.deleteLine(this.cursor.line());
                this.setCursorLine(this.cursor.line() - 1);
                this.setCursorColumn(previousLine.length());
            }
            this.reparseAndStyle();
        }
    }

    private boolean isInIndentation(String beforeCursor) {
        for (char c : beforeCursor.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private int getIndentSize(String beforeCursor) {
        int indentUnitLength = this.indentString.length();
        int length = beforeCursor.length();
        int remainder = length % indentUnitLength;
        if (remainder == 0) {
            return indentUnitLength;
        }
        return remainder;
    }

    public void deleteForwardText() {
        if (this.isSelectionValid()) {
            this.deleteSelection();
        } else if (this.cursor.column() < this.document.getLine(this.cursor.line()).length()) {
            this.document.deleteText(this.cursor.line(), this.cursor.column(), 1);
            this.reparseAndStyle();
        } else if (this.cursor.line() < this.document.getLineCount() - 1) {
            String currentLineText = this.document.getLine(this.cursor.line());
            this.document.deleteLine(this.cursor.line());
            this.document.setLine(this.cursor.line(), currentLineText + this.document.getLine(this.cursor.line()));
            this.reparseAndStyle();
        }
    }

    public void enter() {
        String currentLine = this.document.getLine(this.cursor.line());
        String beforeCursor = currentLine.substring(0, this.cursor.column());
        String afterCursor = currentLine.substring(this.cursor.column());
        String currentIndent = this.getIndentation(beforeCursor);
        String additionalIndent = "";
        if (this.shouldIncreaseIndentation(beforeCursor.trim())) {
            additionalIndent = this.indentString;
        }
        this.document.setLine(this.cursor.line(), beforeCursor);
        String newLineIndent = currentIndent + additionalIndent;
        this.document.insertLine(this.cursor.line() + 1, newLineIndent + afterCursor);
        this.setCursorLine(this.cursor.line() + 1);
        this.setCursorColumn(newLineIndent.length());
        this.reparseAndStyle();
    }

    private String getIndentation(String text) {
        int i;
        for (i = 0; i < text.length() && Character.isWhitespace(text.charAt(i)); ++i) {
        }
        return text.substring(0, i);
    }

    private boolean shouldIncreaseIndentation(String trimmedLine) {
        return this.syntaxParser.getLanguageDefinition().shouldIncreaseIndentation(trimmedLine);
    }

    public void moveCursorUp() {
        if (this.cursor.line() > 0) {
            this.setCursorLine(this.cursor.line() - 1);
            int lineLength = this.document.getLine(this.cursor.line()).length();
            this.setCursorColumn(Math.min(this.cursor.column(), lineLength));
        }
    }

    public void moveCursorDown() {
        if (this.cursor.line() < this.document.getLineCount() - 1) {
            this.setCursorLine(this.cursor.line() + 1);
            int lineLength = this.document.getLine(this.cursor.line()).length();
            this.setCursorColumn(Math.min(this.cursor.column(), lineLength));
        }
    }

    public void moveCursorLeft() {
        if (this.cursor.column() > 0) {
            this.setCursorColumn(this.cursor.column() - 1);
        } else if (this.cursor.line() > 0) {
            this.setCursorLine(this.cursor.line() - 1);
            this.setCursorColumn(this.document.getLine(this.cursor.line()).length());
        }
    }

    public void moveCursorRight() {
        if (this.cursor.column() < this.document.getLine(this.cursor.line()).length()) {
            this.setCursorColumn(this.cursor.column() + 1);
        } else if (this.cursor.line() < this.document.getLineCount() - 1) {
            this.setCursorLine(this.cursor.line() + 1);
            this.setCursorColumn(0);
        }
    }

    public void moveCursorStart() {
        this.setCursor(0, 0);
    }

    public void moveCursorEnd() {
        this.setCursor(this.document.getLineCount() - 1, this.document.getLine(this.document.getLineCount() - 1).length());
    }

    private void reparseAndStyle() {
        this.visibleLinesCache = null;
        this.styledLines.clear();
        for (int i = 0; i < this.document.getLineCount(); ++i) {
            String lineText = this.document.getLine(i);
            List<Token> tokens = this.syntaxParser.parseLine(lineText);
            StyledLine styledLine = new StyledLine(i, this.applyStyles(tokens));
            this.styledLines.add(styledLine);
        }
        this.foldingManager.updateFoldingRegions(this.document);
    }

    private List<StyledText> applyStyles(List<Token> tokens) {
        ArrayList<StyledText> styledTexts = new ArrayList<StyledText>();
        for (Token token : tokens) {
            Style style = this.styleManager.getStyleForTokenType(token.getType());
            styledTexts.add(new StyledText(token.getText(), style));
        }
        return styledTexts;
    }

    public List<StyledLine> getVisibleStyledLines() {
        if (this.visibleLinesCache == null) {
            this.visibleLinesCache = new ArrayList<StyledLine>();
            for (int i = 0; i < this.styledLines.size(); ++i) {
                if (!this.foldingManager.isLineVisible(i)) continue;
                this.visibleLinesCache.add(this.styledLines.get(i));
            }
        }
        return this.visibleLinesCache;
    }

    public void startSelection() {
        this.selection = new Selection(this.cursor, this.cursor);
        this.selection.setSelecting(true);
    }

    public void endSelection() {
        if (this.selection != null) {
            this.selection.setSelecting(false);
        }
    }

    public boolean isSelecting() {
        return this.selection != null && this.selection.isSelecting();
    }

    public void updateSelection() {
        if (this.selection != null && this.selection.isSelecting()) {
            this.selection.updateEnd(this.cursor);
        }
    }

    public boolean isSelectionValid() {
        if (this.selection == null || !this.selection.hasSelection()) {
            return false;
        }
        return this.isCursorValid(this.selection.getStart()) && this.isCursorValid(this.selection.getEnd());
    }

    public void clearSelection() {
        this.selection = null;
    }

    public void selectAll() {
        this.selection = new Selection(new Cursor(0, 0), new Cursor(this.document.getLineCount() - 1, this.document.getLine(this.document.getLineCount() - 1).length()));
    }

    public void deleteSelection() {
        if (this.isSelectionValid()) {
            int[] range = this.selection.getSelectionRange();
            this.deleteRangeInternal(range[0], range[1], range[2], range[3]);
            this.setCursorLine(range[0]);
            this.setCursorColumn(range[1]);
            this.clearSelection();
            this.reparseAndStyle();
        }
    }

    private void deleteRangeInternal(int startLine, int startColumn, int endLine, int endColumn) {
        if (startLine == endLine) {
            String lineText = this.document.getLine(startLine);
            String newLine = lineText.substring(0, startColumn) + lineText.substring(endColumn);
            this.document.setLine(startLine, newLine);
        } else {
            String startLineText = this.document.getLine(startLine);
            String endLineText = this.document.getLine(endLine);
            String newStartLine = startLineText.substring(0, startColumn) + endLineText.substring(endColumn);
            this.document.setLine(startLine, newStartLine);
            for (int i = endLine; i > startLine; --i) {
                this.document.deleteLine(i);
            }
        }
    }

    public String copySelection() {
        if (this.isSelectionValid()) {
            int[] range = this.selection.getSelectionRange();
            return this.getTextInRangeInternal(range[0], range[1], range[2], range[3]);
        }
        return "";
    }

    public String cutSelection() {
        String copiedText = this.copySelection();
        this.deleteSelection();
        return copiedText;
    }

    public void pasteText(String text) {
        if (this.isSelectionValid()) {
            this.deleteSelection();
        }
        this.insertText(text);
    }

    private String getTextInRangeInternal(int startLine, int startColumn, int endLine, int endColumn) {
        StringBuilder sb = new StringBuilder();
        if (startLine == endLine) {
            String lineText = this.document.getLine(startLine);
            sb.append(lineText.substring(startColumn, endColumn));
        } else {
            String lineText = this.document.getLine(startLine);
            sb.append(lineText.substring(startColumn));
            sb.append('\n');
            for (int i = startLine + 1; i < endLine; ++i) {
                sb.append(this.document.getLine(i));
                sb.append('\n');
            }
            lineText = this.document.getLine(endLine);
            sb.append(lineText.substring(0, endColumn));
        }
        return sb.toString();
    }

    public void replaceSelection(String text) {
        this.deleteSelection();
        this.insertText(text);
    }

    public List<String> getLines() {
        return new ArrayList<String>(this.getDocument().getLines());
    }

    public void setLines(List<String> lines) {
        if (lines.equals(this.getLines())) {
            return;
        }
        this.getDocument().getLines().clear();
        for (String text : lines) {
            String[] splits;
            for (String split : splits = text.split("\n", -1)) {
                this.getDocument().insertLine(this.getDocument().getLineCount(), split);
            }
        }
        if (this.getDocument().getLineCount() == 0) {
            this.getDocument().insertLine(0, "");
        }
        if (!this.isCursorValid(this.cursor)) {
            this.setCursor(0, 0);
        }
        this.reparseAndStyle();
    }

    private boolean isCursorValid(Cursor cursor) {
        return cursor.line() >= 0 && cursor.line() < this.document.getLineCount() && cursor.column() >= 0 && cursor.column() <= this.document.getLine(cursor.line()).length();
    }

    public String getIndentString() {
        return this.indentString;
    }

    public Document getDocument() {
        return this.document;
    }

    public SyntaxParser getSyntaxParser() {
        return this.syntaxParser;
    }

    public StyleManager getStyleManager() {
        return this.styleManager;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public FoldingManager getFoldingManager() {
        return this.foldingManager;
    }

    public List<StyledLine> getStyledLines() {
        return this.styledLines;
    }

    @Nullable
    public Selection getSelection() {
        return this.selection;
    }

    public List<StyledLine> getVisibleLinesCache() {
        return this.visibleLinesCache;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }
}

