/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.kjs.graphprocesssor;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortBehavior;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortInput;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortData;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Wrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="eval function", group="graph_processor.node.kjs", modID="kubejs")
public class EvalFunctionNode
extends BaseNode {
    @InputPort
    public String code;
    @InputPort
    public List<Object> args;
    @OutputPort(name="return")
    public Object result;
    @OutputPort(name="return", tips={"return true if the node captures exception, and the result is the error log."})
    public boolean error;
    @Nullable
    private String codeCache;
    @Nullable
    private Function functionCache;

    @Override
    protected void process() {
        ScriptManager manager = ServerScriptManager.getScriptManager();
        Context context = manager.context;
        Scriptable scope = manager.topLevelScope;
        this.result = null;
        this.error = false;
        Function function = this.getFunction();
        if (function != null) {
            try {
                Object object = this.result = function.call(context, scope, scope, this.args.toArray());
                if (object instanceof Wrapper) {
                    Wrapper wrapper = (Wrapper)object;
                    this.result = wrapper.unwrap();
                }
            }
            catch (Exception e) {
                this.error = true;
                this.result = e;
            }
        }
    }

    @Nullable
    public Function getFunction() {
        if (!Objects.equals(this.code, this.codeCache)) {
            this.codeCache = this.code;
            this.functionCache = null;
            if (this.codeCache != null) {
                try {
                    ScriptManager manager = ServerScriptManager.getScriptManager();
                    Context context = manager.context;
                    Scriptable scope = manager.topLevelScope;
                    Object object = context.evaluateString(scope, this.codeCache, this.name(), 1, null);
                    if (object instanceof Function) {
                        Function function;
                        this.functionCache = function = (Function)object;
                    }
                }
                catch (Exception e) {
                    LDLib.LOGGER.error("Failed to compile kjs function \n{}", (Object)this.codeCache, (Object)e);
                }
            }
        }
        return this.functionCache;
    }

    @CustomPortBehavior(field="args")
    public List<PortData> inputPortBehavior(List<PortEdge> edges) {
        ArrayList<PortData> ports = new ArrayList<PortData>();
        for (int i = 0; i < edges.size() + 1; ++i) {
            String identifier = String.valueOf(i);
            if (i < edges.size()) {
                PortEdge edge = edges.get(i);
                edge.inputPortIdentifier = identifier;
            }
            ports.add(new PortData().displayName("arg " + i).identifier(identifier).displayType(Object.class));
        }
        if (this.args == null) {
            this.args = new ArrayList<Object>();
        }
        this.args.clear();
        while (this.args.size() + 1 < ports.size()) {
            this.args.add(null);
        }
        return ports;
    }

    @CustomPortInput(field="args")
    public void pullArgs(List<PortEdge> inputEdges, NodePort inputPort) {
        if (inputEdges.isEmpty()) {
            return;
        }
        Object value = null;
        for (PortEdge inputEdge : inputEdges) {
            if (inputEdge.passThroughBuffer == null) continue;
            value = inputEdge.passThroughBuffer;
            break;
        }
        int index = inputPort.owner.getInputPorts().indexOf(inputPort) - 1;
        while (this.args.size() <= index) {
            this.args.add(value);
        }
        this.args.set(index, value);
    }
}

