/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.syncdata.accessor.ReadonlyAccessor;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import net.minecraft.nbt.Tag;

public class ITagSerializableAccessor
extends ReadonlyAccessor {
    @Override
    public boolean hasPredicate() {
        return true;
    }

    @Override
    public boolean test(Class<?> type) {
        return ITagSerializable.class.isAssignableFrom(type);
    }

    @Override
    public ITypedPayload<?> readFromReadonlyField(AccessorOp op, Object obj) {
        if (!(obj instanceof ITagSerializable)) {
            throw new IllegalArgumentException("Field %s is not ITagSerializable".formatted(obj));
        }
        ITagSerializable serializable = (ITagSerializable)obj;
        Object nbt = serializable.serializeNBT();
        return new NbtTagPayload().setPayload(nbt);
    }

    @Override
    public void writeToReadonlyField(AccessorOp op, Object obj, ITypedPayload<?> payload) {
        if (!(obj instanceof ITagSerializable)) {
            throw new IllegalArgumentException("Field %s is not ITagSerializable".formatted(obj));
        }
        if (!(payload instanceof NbtTagPayload)) {
            throw new IllegalArgumentException("Payload %s is not NbtTagPayload".formatted(payload));
        }
        NbtTagPayload nbtPayload = (NbtTagPayload)payload;
        ((ITagSerializable)obj).deserializeNBT((Tag)nbtPayload.getPayload());
    }
}

