/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.payload;

import com.lowdragmc.lowdraglib.syncdata.SyncedFieldAccessors;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public abstract class PrimitiveTypedPayload<T>
implements ITypedPayload<T> {
    @Override
    public byte getType() {
        return TypedPayloadRegistries.getId(this.getClass());
    }

    @Override
    @Deprecated
    public abstract T getPayload();

    public int getAsInt() {
        if (this instanceof IntPayload) {
            return ((IntPayload)this).value;
        }
        if (this instanceof BytePayload) {
            return ((BytePayload)this).value;
        }
        if (this instanceof ShortPayload) {
            return ((ShortPayload)this).value;
        }
        if (this instanceof LongPayload) {
            return (int)((LongPayload)this).value;
        }
        if (this instanceof FloatPayload) {
            return (int)((FloatPayload)this).value;
        }
        if (this instanceof DoublePayload) {
            return (int)((DoublePayload)this).value;
        }
        throw new IllegalStateException("Cannot get int value from " + this.getClass().getSimpleName());
    }

    public long getAsLong() {
        if (this instanceof LongPayload) {
            return ((LongPayload)this).value;
        }
        if (this instanceof IntPayload) {
            return ((IntPayload)this).value;
        }
        if (this instanceof BytePayload) {
            return ((BytePayload)this).value;
        }
        if (this instanceof ShortPayload) {
            return ((ShortPayload)this).value;
        }
        if (this instanceof FloatPayload) {
            return (long)((FloatPayload)this).value;
        }
        if (this instanceof DoublePayload) {
            return (long)((DoublePayload)this).value;
        }
        throw new IllegalStateException("Cannot get long value from " + this.getClass().getSimpleName());
    }

    public float getAsFloat() {
        if (this instanceof FloatPayload) {
            return ((FloatPayload)this).value;
        }
        if (this instanceof IntPayload) {
            return ((IntPayload)this).value;
        }
        if (this instanceof BytePayload) {
            return ((BytePayload)this).value;
        }
        if (this instanceof ShortPayload) {
            return ((ShortPayload)this).value;
        }
        if (this instanceof LongPayload) {
            return ((LongPayload)this).value;
        }
        if (this instanceof DoublePayload) {
            return (float)((DoublePayload)this).value;
        }
        throw new IllegalStateException("Cannot get float value from " + this.getClass().getSimpleName());
    }

    public double getAsDouble() {
        if (this instanceof DoublePayload) {
            return ((DoublePayload)this).value;
        }
        if (this instanceof IntPayload) {
            return ((IntPayload)this).value;
        }
        if (this instanceof BytePayload) {
            return ((BytePayload)this).value;
        }
        if (this instanceof ShortPayload) {
            return ((ShortPayload)this).value;
        }
        if (this instanceof LongPayload) {
            return ((LongPayload)this).value;
        }
        if (this instanceof FloatPayload) {
            return ((FloatPayload)this).value;
        }
        throw new IllegalStateException("Cannot get double value from " + this.getClass().getSimpleName());
    }

    public byte getAsByte() {
        if (this instanceof BytePayload) {
            return ((BytePayload)this).value;
        }
        if (this instanceof IntPayload) {
            return (byte)((IntPayload)this).value;
        }
        if (this instanceof ShortPayload) {
            return (byte)((ShortPayload)this).value;
        }
        if (this instanceof LongPayload) {
            return (byte)((LongPayload)this).value;
        }
        if (this instanceof FloatPayload) {
            return (byte)((FloatPayload)this).value;
        }
        if (this instanceof DoublePayload) {
            return (byte)((DoublePayload)this).value;
        }
        throw new IllegalStateException("Cannot get byte value from " + this.getClass().getSimpleName());
    }

    public short getAsShort() {
        if (this instanceof ShortPayload) {
            return ((ShortPayload)this).value;
        }
        if (this instanceof IntPayload) {
            return (short)((IntPayload)this).value;
        }
        if (this instanceof BytePayload) {
            return ((BytePayload)this).value;
        }
        if (this instanceof LongPayload) {
            return (short)((LongPayload)this).value;
        }
        if (this instanceof FloatPayload) {
            return (short)((FloatPayload)this).value;
        }
        if (this instanceof DoublePayload) {
            return (short)((DoublePayload)this).value;
        }
        throw new IllegalStateException("Cannot get short value from " + this.getClass().getSimpleName());
    }

    public boolean getAsBoolean() {
        if (this instanceof BooleanPayload) {
            return ((BooleanPayload)this).value;
        }
        throw new IllegalStateException("Cannot get boolean value from " + this.getClass().getSimpleName());
    }

    public char getAsChar() {
        if (this instanceof CharPayload) {
            return ((CharPayload)this).value;
        }
        throw new IllegalStateException("Cannot get char value from " + this.getClass().getSimpleName());
    }

    public boolean isNull() {
        return this instanceof NullPayload;
    }

    public static void registerAll() {
        TypedPayloadRegistries.register(NullPayload.class, () -> NullPayload.INSTANCE, null);
        TypedPayloadRegistries.register(BooleanPayload.class, BooleanPayload::new, SyncedFieldAccessors.BOOLEAN_ACCESSOR);
        TypedPayloadRegistries.register(BytePayload.class, BytePayload::new, SyncedFieldAccessors.BYTE_ACCESSOR);
        TypedPayloadRegistries.register(ShortPayload.class, ShortPayload::new, SyncedFieldAccessors.SHORT_ACCESSOR);
        TypedPayloadRegistries.register(IntPayload.class, IntPayload::new, SyncedFieldAccessors.INT_ACCESSOR);
        TypedPayloadRegistries.register(LongPayload.class, LongPayload::new, SyncedFieldAccessors.LONG_ACCESSOR);
        TypedPayloadRegistries.register(FloatPayload.class, FloatPayload::new, SyncedFieldAccessors.FLOAT_ACCESSOR);
        TypedPayloadRegistries.register(DoublePayload.class, DoublePayload::new, SyncedFieldAccessors.DOUBLE_ACCESSOR);
        TypedPayloadRegistries.register(CharPayload.class, CharPayload::new, SyncedFieldAccessors.CHAR_ACCESSOR);
    }

    public static PrimitiveTypedPayload<Integer> ofInt(int value) {
        IntPayload result = new IntPayload();
        result.value = value;
        return result;
    }

    public static PrimitiveTypedPayload<Long> ofLong(long value) {
        LongPayload result = new LongPayload();
        result.value = value;
        return result;
    }

    public static PrimitiveTypedPayload<Float> ofFloat(float value) {
        FloatPayload result = new FloatPayload();
        result.value = value;
        return result;
    }

    public static PrimitiveTypedPayload<Double> ofDouble(double value) {
        DoublePayload result = new DoublePayload();
        result.value = value;
        return result;
    }

    public static PrimitiveTypedPayload<Byte> ofByte(byte value) {
        BytePayload result = new BytePayload();
        result.value = value;
        return result;
    }

    public static PrimitiveTypedPayload<Short> ofShort(short value) {
        ShortPayload result = new ShortPayload();
        result.value = value;
        return result;
    }

    public static PrimitiveTypedPayload<Boolean> ofBoolean(boolean value) {
        BooleanPayload result = new BooleanPayload();
        result.value = value;
        return result;
    }

    public static PrimitiveTypedPayload<Character> ofChar(char value) {
        CharPayload result = new CharPayload();
        result.value = value;
        return result;
    }

    public static <T> PrimitiveTypedPayload<T> ofNull() {
        return NullPayload.INSTANCE;
    }

    @Nullable
    public static PrimitiveTypedPayload<?> tryOfBoxed(Object object) {
        if (object == null) {
            return PrimitiveTypedPayload.ofNull();
        }
        if (object instanceof Integer) {
            Integer integer = (Integer)object;
            return PrimitiveTypedPayload.ofInt(integer);
        }
        if (object instanceof Long) {
            Long aLong = (Long)object;
            return PrimitiveTypedPayload.ofLong(aLong);
        }
        if (object instanceof Float) {
            Float aFloat = (Float)object;
            return PrimitiveTypedPayload.ofFloat(aFloat.floatValue());
        }
        if (object instanceof Double) {
            Double aDouble = (Double)object;
            return PrimitiveTypedPayload.ofDouble(aDouble);
        }
        if (object instanceof Byte) {
            Byte aByte = (Byte)object;
            return PrimitiveTypedPayload.ofByte(aByte);
        }
        if (object instanceof Short) {
            Short aShort = (Short)object;
            return PrimitiveTypedPayload.ofShort(aShort);
        }
        if (object instanceof Boolean) {
            Boolean aBoolean = (Boolean)object;
            return PrimitiveTypedPayload.ofBoolean(aBoolean);
        }
        if (object instanceof Character) {
            Character character = (Character)object;
            return PrimitiveTypedPayload.ofChar(character.charValue());
        }
        return null;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public static class IntPayload
    extends PrimitiveTypedPayload<Integer> {
        private int value;

        @Override
        public void writePayload(FriendlyByteBuf buf) {
            buf.m_130130_(this.value);
        }

        @Override
        public void readPayload(FriendlyByteBuf buf) {
            this.value = buf.m_130242_();
        }

        @Override
        public Tag serializeNBT() {
            return IntTag.m_128679_((int)this.value);
        }

        @Override
        public void deserializeNBT(Tag tag) {
            this.value = tag instanceof NumericTag ? ((NumericTag)tag).m_7047_() : 0;
        }

        @Override
        public Integer getPayload() {
            return this.value;
        }
    }

    public static class BytePayload
    extends PrimitiveTypedPayload<Byte> {
        private byte value;

        @Override
        public void writePayload(FriendlyByteBuf buf) {
            buf.writeByte((int)this.value);
        }

        @Override
        public void readPayload(FriendlyByteBuf buf) {
            this.value = buf.readByte();
        }

        @Override
        public Tag serializeNBT() {
            return ByteTag.m_128266_((byte)this.value);
        }

        @Override
        public void deserializeNBT(Tag tag) {
            this.value = tag instanceof NumericTag ? ((NumericTag)tag).m_7063_() : (byte)0;
        }

        @Override
        public Byte getPayload() {
            return this.value;
        }
    }

    public static class ShortPayload
    extends PrimitiveTypedPayload<Short> {
        private short value;

        @Override
        public void writePayload(FriendlyByteBuf buf) {
            buf.writeShort((int)this.value);
        }

        @Override
        public void readPayload(FriendlyByteBuf buf) {
            this.value = buf.readShort();
        }

        @Override
        public Tag serializeNBT() {
            return ShortTag.m_129258_((short)this.value);
        }

        @Override
        public void deserializeNBT(Tag tag) {
            this.value = tag instanceof NumericTag ? ((NumericTag)tag).m_7053_() : (short)0;
        }

        @Override
        public Short getPayload() {
            return this.value;
        }
    }

    public static class LongPayload
    extends PrimitiveTypedPayload<Long> {
        private long value;

        @Override
        public void writePayload(FriendlyByteBuf buf) {
            buf.m_130103_(this.value);
        }

        @Override
        public void readPayload(FriendlyByteBuf buf) {
            this.value = buf.m_130258_();
        }

        @Override
        public Tag serializeNBT() {
            return LongTag.m_128882_((long)this.value);
        }

        @Override
        public void deserializeNBT(Tag tag) {
            this.value = tag instanceof NumericTag ? ((NumericTag)tag).m_7046_() : 0L;
        }

        @Override
        public Long getPayload() {
            return this.value;
        }
    }

    public static class FloatPayload
    extends PrimitiveTypedPayload<Float> {
        private float value;

        @Override
        public void writePayload(FriendlyByteBuf buf) {
            buf.writeFloat(this.value);
        }

        @Override
        public void readPayload(FriendlyByteBuf buf) {
            this.value = buf.readFloat();
        }

        @Override
        public Tag serializeNBT() {
            return FloatTag.m_128566_((float)this.value);
        }

        @Override
        public void deserializeNBT(Tag tag) {
            this.value = tag instanceof NumericTag ? ((NumericTag)tag).m_7057_() : 0.0f;
        }

        @Override
        public Float getPayload() {
            return Float.valueOf(this.value);
        }
    }

    public static class DoublePayload
    extends PrimitiveTypedPayload<Double> {
        private double value;

        @Override
        public void writePayload(FriendlyByteBuf buf) {
            buf.writeDouble(this.value);
        }

        @Override
        public void readPayload(FriendlyByteBuf buf) {
            this.value = buf.readDouble();
        }

        @Override
        public Tag serializeNBT() {
            return DoubleTag.m_128500_((double)this.value);
        }

        @Override
        public void deserializeNBT(Tag tag) {
            this.value = tag instanceof NumericTag ? ((NumericTag)tag).m_7061_() : 0.0;
        }

        @Override
        public Double getPayload() {
            return this.value;
        }
    }

    public static class BooleanPayload
    extends PrimitiveTypedPayload<Boolean> {
        private boolean value;

        @Override
        public void writePayload(FriendlyByteBuf buf) {
            buf.writeBoolean(this.value);
        }

        @Override
        public void readPayload(FriendlyByteBuf buf) {
            this.value = buf.readBoolean();
        }

        @Override
        public Tag serializeNBT() {
            return ByteTag.m_128273_((boolean)this.value);
        }

        @Override
        public void deserializeNBT(Tag tag) {
            this.value = tag instanceof NumericTag && ((NumericTag)tag).m_7063_() != 0;
        }

        @Override
        public Boolean getPayload() {
            return this.value;
        }
    }

    public static class CharPayload
    extends PrimitiveTypedPayload<Character> {
        private char value;

        @Override
        public void writePayload(FriendlyByteBuf buf) {
            buf.writeChar((int)this.value);
        }

        @Override
        public void readPayload(FriendlyByteBuf buf) {
            this.value = buf.readChar();
        }

        @Override
        public Tag serializeNBT() {
            return IntTag.m_128679_((int)this.value);
        }

        @Override
        public void deserializeNBT(Tag tag) {
            this.value = tag instanceof NumericTag ? (char)((NumericTag)tag).m_7047_() : (char)'\u0000';
        }

        @Override
        public Character getPayload() {
            return Character.valueOf(this.value);
        }
    }

    public static class NullPayload
    extends PrimitiveTypedPayload<Object> {
        private static final NullPayload INSTANCE = new NullPayload();

        private NullPayload() {
        }

        @Override
        public void writePayload(FriendlyByteBuf buf) {
        }

        @Override
        public void readPayload(FriendlyByteBuf buf) {
        }

        @Override
        public Tag serializeNBT() {
            return null;
        }

        @Override
        public void deserializeNBT(Tag tag) {
        }

        @Override
        public Object getPayload() {
            return null;
        }
    }
}

