/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.LDLib;
import net.minecraft.util.Mth;

public class ColorUtils {
    public static int randomColor(int minR, int maxR, int minG, int maxG, int minB, int maxB) {
        return 0xFF000000 | minR + LDLib.random.nextInt(maxR + 1 - minR) << 16 | minG + LDLib.random.nextInt(maxG + 1 - minG) << 8 | minB + LDLib.random.nextInt(maxB + 1 - minB);
    }

    public static int randomColor(int minA, int maxA, int minR, int maxR, int minG, int maxG, int minB, int maxB) {
        return minR + LDLib.random.nextInt(maxA + 1 - minA) << 24 | minR + LDLib.random.nextInt(maxR + 1 - minR) << 16 | minG + LDLib.random.nextInt(maxG + 1 - minG) << 8 | minB + LDLib.random.nextInt(maxB + 1 - minB);
    }

    public static int randomColor(int colorA, int colorB) {
        return ColorUtils.randomColor(Math.min(ColorUtils.alphaI(colorA), ColorUtils.alphaI(colorB)), Math.max(ColorUtils.alphaI(colorA), ColorUtils.alphaI(colorB)), Math.min(ColorUtils.redI(colorA), ColorUtils.redI(colorB)), Math.max(ColorUtils.redI(colorA), ColorUtils.redI(colorB)), Math.min(ColorUtils.greenI(colorA), ColorUtils.greenI(colorB)), Math.max(ColorUtils.greenI(colorA), ColorUtils.greenI(colorB)), Math.min(ColorUtils.blueI(colorA), ColorUtils.blueI(colorB)), Math.max(ColorUtils.blueI(colorA), ColorUtils.blueI(colorB)));
    }

    public static int randomColor() {
        return ColorUtils.randomColor(0, 255, 0, 255, 0, 255);
    }

    public static int averageColor(int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int color : colors) {
            r += color >> 16 & 0xFF;
            g += color >> 8 & 0xFF;
            b += color & 0xFF;
        }
        return r / colors.length << 16 | g / colors.length << 8 | b / colors.length;
    }

    public static double softLightBlend(double bg, double fg, double alphaBg, double alphaFg) {
        double newColor = fg <= 0.5 ? 2.0 * bg * fg + bg * bg * (1.0 - 2.0 * fg) : Math.sqrt(bg) * (2.0 * fg - 1.0) + 2.0 * bg * (1.0 - fg);
        newColor = alphaFg * newColor + alphaBg * (1.0 - alphaFg) * newColor;
        return newColor;
    }

    public static float alpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static float red(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float green(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float blue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static int alphaI(int color) {
        return color >> 24 & 0xFF;
    }

    public static int redI(int color) {
        return color >> 16 & 0xFF;
    }

    public static int greenI(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blueI(int color) {
        return color & 0xFF;
    }

    public static int color(int alpha, int red, int green, int blue) {
        if (alpha > 255) {
            alpha = 255;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int color(float alpha, float red, float green, float blue) {
        return ColorUtils.color((int)(alpha * 255.0f), (int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f));
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float[] RGBtoHSB(int color) {
        float hue;
        int cmin;
        int b = color & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int cmax = Math.max(r, g);
        if (b > cmax) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g))) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new float[]{hue, saturation, brightness};
    }

    public static int blendColor(int color0, int color1, float lerp) {
        return ColorUtils.color(Mth.m_14179_((float)lerp, (float)ColorUtils.alpha(color0), (float)ColorUtils.alpha(color1)), Mth.m_14179_((float)lerp, (float)ColorUtils.red(color0), (float)ColorUtils.red(color1)), Mth.m_14179_((float)lerp, (float)ColorUtils.green(color0), (float)ColorUtils.green(color1)), Mth.m_14179_((float)lerp, (float)ColorUtils.blue(color0), (float)ColorUtils.blue(color1)));
    }
}

