/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CycleFluidStorage
implements IFluidStorage {
    private List<FluidStack> storages;
    private long capacity;

    public CycleFluidStorage(long capacity, List<FluidStack> storages) {
        this.setCapacity(capacity);
        this.updateStacks(storages);
    }

    public void updateStacks(List<FluidStack> storages) {
        this.storages = storages;
    }

    @Override
    @NotNull
    public FluidStack getFluid() {
        return this.storages == null || this.storages.isEmpty() ? FluidStack.empty() : this.storages.get(Math.abs((int)(System.currentTimeMillis() / 1000L) % this.storages.size()));
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.updateStacks(List.of(fluid));
    }

    @Override
    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return 0L;
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    @Override
    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return FluidStack.empty();
    }

    @Override
    public boolean supportsDrain(int tank) {
        return false;
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return new Object();
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }
}

