/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.common.blocks;

import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.api.ChemicalBlockType;
import com.smashingmods.chemlib.api.MatterState;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.ForgeRegistries;

public class ChemicalBlock
extends Block
implements Chemical {
    private final ResourceLocation chemical;
    private final ChemicalBlockType blockType;

    public ChemicalBlock(ResourceLocation pChemical, ChemicalBlockType pBlockType, List<ChemicalBlock> pList, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.chemical = pChemical;
        this.blockType = pBlockType;
        pList.add(this);
    }

    public Chemical getChemical() {
        return (Chemical)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(this.chemical));
    }

    public ChemicalBlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public String getChemicalName() {
        return this.getChemical().getChemicalName();
    }

    @Override
    public String getAbbreviation() {
        return this.getChemical().getAbbreviation();
    }

    @Override
    public MatterState getMatterState() {
        return MatterState.SOLID;
    }

    @Override
    public String getChemicalDescription() {
        return "";
    }

    @Override
    public List<MobEffectInstance> getEffects() {
        return this.getChemical().getEffects();
    }

    @Override
    public int getColor() {
        return this.clampMinColorValue(this.getChemical().getColor(), 68);
    }

    public BlockColor getBlockColor(ItemStack pItemStack, int pTintIndex) {
        return (pState, pLevel, pPos, pTintIndex1) -> this.getChemical().getColor();
    }
}

