/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.datagen;

import com.smashingmods.chemlib.api.ChemicalBlockType;
import com.smashingmods.chemlib.registry.BlockRegistry;
import com.smashingmods.chemlib.registry.FluidRegistry;
import com.smashingmods.chemlib.registry.ItemRegistry;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class LocalizationGenerator
extends LanguageProvider {
    public LocalizationGenerator(PackOutput pOutput, String locale) {
        super(pOutput, "chemlib", locale);
    }

    protected void addTranslations() {
        ItemRegistry.getElements().forEach(element -> this.add(String.format("item.chemlib.%s", element.getChemicalName()), StringUtils.capitalize((String)element.getChemicalName())));
        ItemRegistry.getCompounds().forEach(compound -> {
            this.add(String.format("item.chemlib.%s", compound.getChemicalName()), WordUtils.capitalize((String)compound.getChemicalName().replace("_", " ")));
            if (!compound.getChemicalDescription().isEmpty()) {
                this.add(String.format("%s.jei.compound.%s.description", "chemlib", compound.getChemicalName()), compound.getChemicalDescription());
            }
        });
        ItemRegistry.getChemicalItems().forEach(item -> {
            String name = item.getChemicalName();
            String itemType = item.getItemType().m_7912_();
            this.add(String.format("item.chemlib.%s_%s", name, itemType), WordUtils.capitalize((String)String.format("%s %s", name.replace("_", " "), itemType)));
        });
        for (ChemicalBlockType type : ChemicalBlockType.values()) {
            BlockRegistry.getChemicalBlocksStreamByType(type).forEach(block -> {
                String name = block.getChemicalName();
                String displayType = type.equals((Object)ChemicalBlockType.METAL) ? "block" : "lamp";
                this.add(String.format("block.chemlib.%s_%s_block", name, type.m_7912_()), WordUtils.capitalize((String)String.format("%s %s", name, displayType)));
            });
        }
        FluidRegistry.FLUID_TYPES.getEntries().stream().map(RegistryObject::get).forEach(fluidType -> {
            int density = fluidType.getDensity();
            String key = fluidType.getDescriptionId();
            String value = key.split("\\.")[key.split("\\.").length - 1];
            String translation = WordUtils.capitalize((String)String.format("%s%s", value.replace("_", " "), density < 0 ? " gas" : ""));
            this.add(key, translation);
            this.add(String.format("item.chemlib.%s_bucket", value), translation + " Bucket");
        });
        this.add("item.chemlib.periodic_table", "Periodic Table of the Elements");
        this.add("item.chemlib.periodic_table.tooltip", "Use this to see a full periodic table.");
        this.add("itemGroup.chemlib.elements", "Elements");
        this.add("itemGroup.chemlib.compounds", "Compounds");
        this.add("itemGroup.chemlib.metals", "Metals");
        this.add("itemGroup.chemlib.misc", "Misc Items");
        this.add("chemlib.effect.on_hit", "Effects on Hit");
        this.add("chemlib.screen.periodic_table", "Periodic Table of the Elements");
        this.add("chemlib.jei.element.description", "Use the Periodic Table of the Elements to learn more about this element.");
    }
}

