/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity.data;

import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BlockEntitySynchronizationSpec {
    private final List<BlockEntitySynchronizationParameter> parameters;
    private final List<BlockEntitySynchronizationParameter> watchedParameters;

    public BlockEntitySynchronizationSpec(List<BlockEntitySynchronizationParameter> parameters, List<BlockEntitySynchronizationParameter> watchedParameters) {
        this.parameters = Collections.unmodifiableList(parameters);
        this.watchedParameters = Collections.unmodifiableList(watchedParameters);
    }

    public List<BlockEntitySynchronizationParameter> getParameters() {
        return this.parameters;
    }

    public List<BlockEntitySynchronizationParameter> getWatchedParameters() {
        return this.watchedParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<BlockEntitySynchronizationParameter> parameters = new ArrayList<BlockEntitySynchronizationParameter>();
        private final List<BlockEntitySynchronizationParameter> watchedParameters = new ArrayList<BlockEntitySynchronizationParameter>();

        public Builder addParameter(BlockEntitySynchronizationParameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public Builder addWatchedParameter(BlockEntitySynchronizationParameter parameter) {
            this.addParameter(parameter);
            this.watchedParameters.add(parameter);
            return this;
        }

        public BlockEntitySynchronizationSpec build() {
            return new BlockEntitySynchronizationSpec(this.parameters, this.watchedParameters);
        }
    }
}

