/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.craftingtweaks;

import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.container.slot.grid.CraftingGridSlot;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;

public final class CraftingTweaksIntegration {
    private static final String ID = "craftingtweaks";

    private CraftingTweaksIntegration() {
    }

    public static boolean isLoaded() {
        return ModList.get().isLoaded(ID);
    }

    public static boolean isCraftingTweaksClass(Class<?> clazz) {
        return clazz.getName().startsWith("net.blay09.mods.craftingtweaks");
    }

    public static void register() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("ContainerClass", GridContainerMenu.class.getName());
        tag.m_128359_("ValidContainerPredicate", ValidContainerPredicate.class.getName());
        tag.m_128359_("GetGridStartFunction", GetGridStartFunction.class.getName());
        tag.m_128359_("AlignToGrid", "left");
        InterModComms.sendTo((String)ID, (String)"RegisterProvider", () -> tag);
    }

    public static class ValidContainerPredicate
    implements Predicate<GridContainerMenu> {
        @Override
        public boolean test(GridContainerMenu containerGrid) {
            return containerGrid.getGrid().getGridType() == GridType.CRAFTING;
        }
    }

    public static class GetGridStartFunction
    implements Function<GridContainerMenu, Integer> {
        @Override
        public Integer apply(GridContainerMenu containerGrid) {
            for (int i = 0; i < containerGrid.f_38839_.size(); ++i) {
                if (!(containerGrid.f_38839_.get(i) instanceof CraftingGridSlot)) continue;
                return i;
            }
            return 0;
        }
    }
}

