/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSContainerMenus;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.integration.jei.Ingredient;
import com.refinedmods.refinedstorage.integration.jei.IngredientTracker;
import com.refinedmods.refinedstorage.integration.jei.RecipeTransferCraftingGridError;
import com.refinedmods.refinedstorage.integration.jei.RecipeTransferPatternGridError;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewRequestMessage;
import com.refinedmods.refinedstorage.network.grid.GridProcessingTransferMessage;
import com.refinedmods.refinedstorage.network.grid.GridTransferMessage;
import com.refinedmods.refinedstorage.screen.IScreenInfoProvider;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class GridRecipeTransferHandler
implements IRecipeTransferHandler<GridContainerMenu, Object> {
    public static final GridRecipeTransferHandler INSTANCE = new GridRecipeTransferHandler();
    private static final long TRANSFER_SCROLLBAR_DELAY_MS = 200L;
    private long lastTransferTimeMs;

    private GridRecipeTransferHandler() {
    }

    public Class<GridContainerMenu> getContainerClass() {
        return GridContainerMenu.class;
    }

    public Optional<MenuType<GridContainerMenu>> getMenuType() {
        return Optional.of((MenuType)RSContainerMenus.GRID.get());
    }

    public RecipeType<Object> getRecipeType() {
        return null;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(GridContainerMenu container, Object recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        IScreenInfoProvider iScreenInfoProvider = container.getScreenInfoProvider();
        if (!(iScreenInfoProvider instanceof GridScreen)) {
            return null;
        }
        GridScreen gridScreen = (GridScreen)iScreenInfoProvider;
        gridScreen.runActions();
        Ingredient.IngredientList ingredientList = new Ingredient.IngredientList();
        for (IRecipeSlotView slotView : recipeSlots.getSlotViews(RecipeIngredientRole.INPUT)) {
            Optional<ItemStack> firstStack = slotView.getItemStacks().findAny();
            ingredientList.add(new Ingredient(slotView, firstStack.map(ItemStack::m_41613_).orElse(0)));
        }
        IngredientTracker tracker = IngredientTracker.getTracker(container);
        tracker.updateAvailability(ingredientList, container, player);
        GridType type = container.getGrid().getGridType();
        if (type == GridType.CRAFTING) {
            return this.transferRecipeForCraftingGrid(container, recipe, recipeSlots, player, doTransfer, ingredientList);
        }
        if (type == GridType.PATTERN) {
            return this.transferRecipeForPatternGrid(container, recipe, recipeSlots, player, doTransfer, ingredientList);
        }
        return null;
    }

    private RecipeTransferCraftingGridError transferRecipeForCraftingGrid(GridContainerMenu container, Object recipe, IRecipeSlotsView recipeLayout, Player player, boolean doTransfer, Ingredient.IngredientList ingredientList) {
        if (doTransfer) {
            if (ingredientList.hasMissingButAutocraftingAvailable() && Screen.m_96637_()) {
                ingredientList.createCraftingRequests().forEach((id, count) -> RS.NETWORK_HANDLER.sendToServer(new GridCraftingPreviewRequestMessage((UUID)id, (int)count, Screen.m_96638_(), false)));
            } else {
                this.moveItems(container, recipe, recipeLayout, player);
            }
        } else if (ingredientList.hasMissing()) {
            return new RecipeTransferCraftingGridError(ingredientList);
        }
        return null;
    }

    private IRecipeTransferError transferRecipeForPatternGrid(GridContainerMenu container, Object recipe, IRecipeSlotsView recipeLayout, Player player, boolean doTransfer, Ingredient.IngredientList ingredientList) {
        if (doTransfer) {
            this.moveItems(container, recipe, recipeLayout, player);
        } else if (ingredientList.isAutocraftingAvailable()) {
            return new RecipeTransferPatternGridError(ingredientList);
        }
        return null;
    }

    public boolean hasTransferredRecently() {
        return System.currentTimeMillis() - this.lastTransferTimeMs <= 200L;
    }

    private void moveItems(GridContainerMenu gridContainer, Object recipe, IRecipeSlotsView recipeLayout, Player player) {
        this.lastTransferTimeMs = System.currentTimeMillis();
        boolean isCraftingRecipe = false;
        if (recipe instanceof Recipe) {
            Recipe castRecipe = (Recipe)recipe;
            boolean bl = isCraftingRecipe = castRecipe.m_6671_() == net.minecraft.world.item.crafting.RecipeType.f_44107_;
        }
        if (gridContainer.getGrid().getGridType() == GridType.PATTERN && !isCraftingRecipe) {
            this.moveForProcessing(recipeLayout, gridContainer, player);
        } else {
            this.move(recipeLayout);
        }
    }

    private void move(IRecipeSlotsView recipeSlotsView) {
        List<List<ItemStack>> inputs = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).stream().map(view -> {
            List stacks = view.getItemStacks().collect(Collectors.toCollection(ArrayList::new));
            Optional displayStack = view.getDisplayedItemStack();
            displayStack.ifPresent(stack -> {
                int index = stacks.indexOf(stack);
                if (index > -1) {
                    stacks.remove(index);
                    stacks.add(0, stack);
                }
            });
            return stacks;
        }).toList();
        RS.NETWORK_HANDLER.sendToServer(new GridTransferMessage(inputs));
    }

    private void moveForProcessing(IRecipeSlotsView recipeLayout, GridContainerMenu gridContainer, Player player) {
        LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputs = new LinkedList<ItemStack>();
        LinkedList<FluidStack> fluidInputs = new LinkedList<FluidStack>();
        LinkedList<FluidStack> fluidOutputs = new LinkedList<FluidStack>();
        List inputSlots = recipeLayout.getSlotViews(RecipeIngredientRole.INPUT);
        for (IRecipeSlotView view : inputSlots) {
            this.handleItemIngredient(inputs, view, gridContainer, player);
            this.handleFluidIngredient(fluidInputs, view);
        }
        List outputSlots = recipeLayout.getSlotViews(RecipeIngredientRole.OUTPUT);
        for (IRecipeSlotView view : outputSlots) {
            this.handleItemIngredient(outputs, view, gridContainer, player);
            this.handleFluidIngredient(fluidOutputs, view);
        }
        RS.NETWORK_HANDLER.sendToServer(new GridProcessingTransferMessage(inputs, outputs, fluidInputs, fluidOutputs));
    }

    private void handleFluidIngredient(List<FluidStack> list, IRecipeSlotView slotView) {
        if (slotView != null) {
            slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(list::add);
        }
    }

    private void handleItemIngredient(List<ItemStack> list, IRecipeSlotView slotView, GridContainerMenu gridContainer, Player player) {
        if (slotView != null && slotView.getItemStacks().findAny().isPresent()) {
            ItemStack stack = IngredientTracker.getTracker(gridContainer).findBestMatch(gridContainer, player, slotView.getItemStacks().toList());
            if (stack.m_41619_() && slotView.getDisplayedItemStack().isPresent()) {
                stack = (ItemStack)slotView.getDisplayedItemStack().get();
            }
            if (!stack.m_41619_()) {
                list.add(stack);
            }
        }
    }
}

