/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.craftingmonitor;

import com.refinedmods.refinedstorage.container.CraftingMonitorContainerMenu;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CraftingMonitorCancelMessage {
    @Nullable
    private final UUID taskId;

    public CraftingMonitorCancelMessage(@Nullable UUID taskId) {
        this.taskId = taskId;
    }

    public static CraftingMonitorCancelMessage decode(FriendlyByteBuf buf) {
        return new CraftingMonitorCancelMessage(buf.readBoolean() ? buf.m_130259_() : null);
    }

    public static void encode(CraftingMonitorCancelMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.taskId != null);
        if (message.taskId != null) {
            buf.m_130077_(message.taskId);
        }
    }

    public static void handle(CraftingMonitorCancelMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                if (player.f_36096_ instanceof CraftingMonitorContainerMenu) {
                    ((CraftingMonitorContainerMenu)player.f_36096_).getCraftingMonitor().onCancelled(player, message.taskId);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

