/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class GridItemInsertHeldMessage {
    private final boolean single;

    public GridItemInsertHeldMessage(boolean single) {
        this.single = single;
    }

    public static GridItemInsertHeldMessage decode(FriendlyByteBuf buf) {
        return new GridItemInsertHeldMessage(buf.readBoolean());
    }

    public static void encode(GridItemInsertHeldMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.single);
    }

    public static void handle(GridItemInsertHeldMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                IGrid grid;
                AbstractContainerMenu container = player.f_36096_;
                if (container instanceof GridContainerMenu && (grid = ((GridContainerMenu)container).getGrid()).getItemHandler() != null) {
                    grid.getItemHandler().onInsertHeldItem(player, message.single);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

