/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.util;

import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.screen.grid.stack.FluidGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import com.refinedmods.refinedstorage.util.PacketBufferUtils;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StackUtils {
    public static final ItemStack EMPTY_BUCKET = new ItemStack((ItemLike)Items.f_42446_);
    private static final String NBT_INVENTORY = "Inventory_%d";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_FORGE_CAPS = "ForgeCaps";
    private static final Logger LOGGER = LogManager.getLogger(StackUtils.class);
    private static final String NBT_ITEM_ID = "Id";
    private static final String NBT_ITEM_QUANTITY = "Quantity";
    private static final String NBT_ITEM_NBT = "NBT";
    private static final String NBT_ITEM_CAPS = "Caps";

    private StackUtils() {
    }

    public static void writeItemStack(FriendlyByteBuf buf, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            Item item = stack.m_41720_();
            buf.m_130130_(Item.m_41393_((Item)item));
            buf.writeInt(stack.m_41613_());
            CompoundTag tag = null;
            if (item.m_41465_() || item.m_41468_()) {
                tag = stack.m_41783_();
            }
            buf.m_130079_(tag);
        }
    }

    public static ItemStack readItemStack(FriendlyByteBuf buf) {
        if (!buf.readBoolean()) {
            return ItemStack.f_41583_;
        }
        int id = buf.m_130242_();
        int count = buf.readInt();
        ItemStack stack = new ItemStack((ItemLike)Item.m_41445_((int)id), count);
        stack.readShareTag(buf.m_130260_());
        return stack;
    }

    public static void writeItemGridStack(FriendlyByteBuf buf, ItemStack stack, UUID id, @Nullable UUID otherId, boolean craftable, @Nullable StorageTrackerEntry entry) {
        StackUtils.writeItemStack(buf, stack);
        buf.writeBoolean(craftable);
        buf.m_130077_(id);
        buf.writeBoolean(otherId != null);
        if (otherId != null) {
            buf.m_130077_(otherId);
        }
        if (entry == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(entry.getTime());
            buf.m_130070_(entry.getName());
        }
    }

    public static ItemGridStack readItemGridStack(FriendlyByteBuf buf) {
        ItemStack stack = StackUtils.readItemStack(buf);
        boolean craftable = buf.readBoolean();
        UUID id = buf.m_130259_();
        UUID otherId = null;
        if (buf.readBoolean()) {
            otherId = buf.m_130259_();
        }
        StorageTrackerEntry entry = null;
        if (buf.readBoolean()) {
            entry = new StorageTrackerEntry(buf.readLong(), PacketBufferUtils.readString(buf));
        }
        return new ItemGridStack(id, otherId, stack, craftable, entry);
    }

    public static void writeFluidGridStack(FriendlyByteBuf buf, FluidStack stack, UUID id, @Nullable UUID otherId, boolean craftable, @Nullable StorageTrackerEntry entry) {
        stack.writeToPacket(buf);
        buf.writeBoolean(craftable);
        buf.m_130077_(id);
        buf.writeBoolean(otherId != null);
        if (otherId != null) {
            buf.m_130077_(otherId);
        }
        if (entry == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(entry.getTime());
            buf.m_130070_(entry.getName());
        }
    }

    public static FluidGridStack readFluidGridStack(FriendlyByteBuf buf) {
        FluidStack stack = FluidStack.readFromPacket((FriendlyByteBuf)buf);
        boolean craftable = buf.readBoolean();
        UUID id = buf.m_130259_();
        UUID otherId = null;
        if (buf.readBoolean()) {
            otherId = buf.m_130259_();
        }
        StorageTrackerEntry entry = null;
        if (buf.readBoolean()) {
            entry = new StorageTrackerEntry(buf.readLong(), PacketBufferUtils.readString(buf));
        }
        return new FluidGridStack(id, otherId, stack, entry, craftable);
    }

    public static void createStorages(ServerLevel level, ItemStack diskStack, int slot, IStorageDisk<ItemStack>[] itemDisks, IStorageDisk<FluidStack>[] fluidDisks, Function<IStorageDisk<ItemStack>, IStorageDisk> itemDiskWrapper, Function<IStorageDisk<FluidStack>, IStorageDisk> fluidDiskWrapper) {
        if (diskStack.m_41619_()) {
            itemDisks[slot] = null;
            fluidDisks[slot] = null;
        } else {
            IStorageDisk disk = API.instance().getStorageDiskManager(level).getByStack(diskStack);
            if (disk != null) {
                StorageType type = ((IStorageDiskProvider)diskStack.m_41720_()).getType();
                if (type == StorageType.ITEM) {
                    itemDisks[slot] = itemDiskWrapper.apply(disk);
                } else if (type == StorageType.FLUID) {
                    fluidDisks[slot] = fluidDiskWrapper.apply(disk);
                }
            } else {
                itemDisks[slot] = null;
                fluidDisks[slot] = null;
            }
        }
    }

    public static void writeItems(IItemHandler handler, int id, CompoundTag tag, Function<ItemStack, CompoundTag> serializer) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            CompoundTag stackTag = serializer.apply(handler.getStackInSlot(i));
            stackTag.m_128405_(NBT_SLOT, i);
            tagList.add((Object)stackTag);
        }
        tag.m_128365_(String.format(NBT_INVENTORY, id), (Tag)tagList);
    }

    public static void writeItems(IItemHandler handler, int id, CompoundTag tag) {
        StackUtils.writeItems(handler, id, tag, stack -> stack.m_41739_(new CompoundTag()));
    }

    public static void readItems(IItemHandlerModifiable handler, int id, CompoundTag tag, Function<CompoundTag, ItemStack> deserializer) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.m_128441_(name)) {
            ListTag tagList = tag.m_128437_(name, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                int slot = tagList.m_128728_(i).m_128451_(NBT_SLOT);
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.setStackInSlot(slot, deserializer.apply(tagList.m_128728_(i)));
            }
        }
    }

    public static void readItems(IItemHandlerModifiable handler, int id, CompoundTag tag) {
        StackUtils.readItems(handler, id, tag, ItemStack::m_41712_);
    }

    public static void readItems(BaseItemHandler handler, int id, CompoundTag tag) {
        handler.setReading(true);
        StackUtils.readItems((IItemHandlerModifiable)handler, id, tag, ItemStack::m_41712_);
        handler.setReading(false);
    }

    public static void writeItems(Container inventory, int id, CompoundTag tag) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128405_(NBT_SLOT, i);
            inventory.m_8020_(i).m_41739_(stackTag);
            tagList.add((Object)stackTag);
        }
        tag.m_128365_(String.format(NBT_INVENTORY, id), (Tag)tagList);
    }

    public static void readItems(Container inventory, int id, CompoundTag tag) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.m_128441_(name)) {
            ListTag tagList = tag.m_128437_(name, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                int slot = tagList.m_128728_(i).m_128451_(NBT_SLOT);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)tagList.m_128728_(i));
                if (stack.m_41619_()) continue;
                inventory.m_6836_(slot, stack);
            }
        }
    }

    public static FluidStack copy(FluidStack stack, int size) {
        FluidStack copy = stack.copy();
        copy.setAmount(size);
        return copy;
    }

    public static FluidStack copy(@Nullable FluidStack stack) {
        return stack == null ? null : stack.copy();
    }

    public static Pair<ItemStack, FluidStack> getFluid(ItemStack stack, boolean simulate) {
        IFluidHandlerItem handler;
        if (stack.m_41619_()) {
            return Pair.of((Object)ItemStack.f_41583_, (Object)FluidStack.EMPTY);
        }
        if (stack.m_41613_() > 1) {
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        }
        if ((handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse(null)) != null) {
            FluidStack result = handler.drain(1000, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            return Pair.of((Object)handler.getContainer(), (Object)result);
        }
        return Pair.of((Object)ItemStack.f_41583_, (Object)FluidStack.EMPTY);
    }

    public static CompoundTag serializeStackToNbt(@Nonnull ItemStack stack) {
        CompoundTag dummy = new CompoundTag();
        CompoundTag itemTag = new CompoundTag();
        ResourceLocation key = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), "Item is not registered");
        itemTag.m_128359_(NBT_ITEM_ID, key.toString());
        itemTag.m_128405_(NBT_ITEM_QUANTITY, stack.m_41613_());
        if (stack.m_41782_()) {
            itemTag.m_128365_(NBT_ITEM_NBT, (Tag)stack.m_41783_());
        }
        stack.m_41739_(dummy);
        if (dummy.m_128441_(NBT_FORGE_CAPS)) {
            itemTag.m_128365_(NBT_ITEM_CAPS, dummy.m_128423_(NBT_FORGE_CAPS));
        }
        dummy.m_128473_(NBT_FORGE_CAPS);
        return itemTag;
    }

    @Nonnull
    public static ItemStack deserializeStackFromNbt(CompoundTag tag) {
        Item item;
        if (tag.m_128441_(NBT_ITEM_ID)) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.m_128461_(NBT_ITEM_ID)));
            if (item == null) {
                LOGGER.warn("Could not deserialize item from string ID {}, it no longer exists", (Object)tag.m_128461_(NBT_ITEM_ID));
            }
        } else {
            throw new IllegalStateException("Cannot deserialize ItemStack: no Id tag was found!");
        }
        if (item == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)item, tag.m_128451_(NBT_ITEM_QUANTITY), tag.m_128441_(NBT_ITEM_CAPS) ? tag.m_128469_(NBT_ITEM_CAPS) : null);
        stack.m_41751_(tag.m_128441_(NBT_ITEM_NBT) ? tag.m_128469_(NBT_ITEM_NBT) : null);
        return stack;
    }
}

