/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers;

import java.util.ArrayList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import thetadev.constructionwand.api.IContainerHandler;

public class ContainerManager {
    private final ArrayList<IContainerHandler> handlers = new ArrayList();

    public boolean register(IContainerHandler handler) {
        return this.handlers.add(handler);
    }

    public int countItems(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        for (IContainerHandler handler : this.handlers) {
            if (!handler.matches(player, itemStack, inventoryStack)) continue;
            return handler.countItems(player, itemStack, inventoryStack);
        }
        return 0;
    }

    public int useItems(Player player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        for (IContainerHandler handler : this.handlers) {
            if (!handler.matches(player, itemStack, inventoryStack)) continue;
            return handler.useItems(player, itemStack, inventoryStack, count);
        }
        return count;
    }
}

