/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import thetadev.constructionwand.api.IWandAction;
import thetadev.constructionwand.api.IWandSupplier;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.wand.undo.DestroySnapshot;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class ActionDestruction
implements IWandAction {
    @Override
    public int getLimit(ItemStack wand) {
        return ConfigServer.getWandProperties(wand.m_41720_()).getDestruction();
    }

    @Override
    @Nonnull
    public List<ISnapshot> getSnapshots(Level world, Player player, BlockHitResult rayTraceResult, ItemStack wand, WandOptions options, IWandSupplier supplier, int limit) {
        LinkedList<ISnapshot> destroySnapshots = new LinkedList<ISnapshot>();
        LinkedList<BlockPos> candidates = new LinkedList<BlockPos>();
        HashSet<BlockPos> allCandidates = new HashSet<BlockPos>();
        Direction breakFace = rayTraceResult.m_82434_();
        BlockPos startingPoint = rayTraceResult.m_82425_();
        BlockState targetBlock = world.m_8055_(rayTraceResult.m_82425_());
        if (breakFace == Direction.UP || breakFace == Direction.DOWN) {
            if (options.testLock(WandOptions.LOCK.NORTHSOUTH) || options.testLock(WandOptions.LOCK.EASTWEST)) {
                candidates.add(startingPoint);
            }
        } else if (options.testLock(WandOptions.LOCK.HORIZONTAL) || options.testLock(WandOptions.LOCK.VERTICAL)) {
            candidates.add(startingPoint);
        }
        while (!candidates.isEmpty() && destroySnapshots.size() < limit) {
            BlockPos currentCandidate = (BlockPos)candidates.removeFirst();
            if (!WandUtil.isBlockPermeable(world, currentCandidate.m_121955_(breakFace.m_122436_()))) continue;
            try {
                DestroySnapshot snapshot;
                BlockState candidateBlock = world.m_8055_(currentCandidate);
                if (!options.matchBlocks(targetBlock.m_60734_(), candidateBlock.m_60734_()) || !allCandidates.add(currentCandidate) || (snapshot = DestroySnapshot.get(world, player, currentCandidate)) == null) continue;
                destroySnapshots.add(snapshot);
                switch (breakFace) {
                    case DOWN: 
                    case UP: {
                        if (options.testLock(WandOptions.LOCK.NORTHSOUTH)) {
                            candidates.add(currentCandidate.m_121955_(Direction.NORTH.m_122436_()));
                            candidates.add(currentCandidate.m_121955_(Direction.SOUTH.m_122436_()));
                        }
                        if (options.testLock(WandOptions.LOCK.EASTWEST)) {
                            candidates.add(currentCandidate.m_121955_(Direction.EAST.m_122436_()));
                            candidates.add(currentCandidate.m_121955_(Direction.WEST.m_122436_()));
                        }
                        if (!options.testLock(WandOptions.LOCK.NORTHSOUTH) || !options.testLock(WandOptions.LOCK.EASTWEST)) break;
                        candidates.add(currentCandidate.m_121955_(Direction.NORTH.m_122436_()).m_121955_(Direction.EAST.m_122436_()));
                        candidates.add(currentCandidate.m_121955_(Direction.NORTH.m_122436_()).m_121955_(Direction.WEST.m_122436_()));
                        candidates.add(currentCandidate.m_121955_(Direction.SOUTH.m_122436_()).m_121955_(Direction.EAST.m_122436_()));
                        candidates.add(currentCandidate.m_121955_(Direction.SOUTH.m_122436_()).m_121955_(Direction.WEST.m_122436_()));
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        if (options.testLock(WandOptions.LOCK.HORIZONTAL)) {
                            candidates.add(currentCandidate.m_121955_(Direction.EAST.m_122436_()));
                            candidates.add(currentCandidate.m_121955_(Direction.WEST.m_122436_()));
                        }
                        if (options.testLock(WandOptions.LOCK.VERTICAL)) {
                            candidates.add(currentCandidate.m_121955_(Direction.UP.m_122436_()));
                            candidates.add(currentCandidate.m_121955_(Direction.DOWN.m_122436_()));
                        }
                        if (!options.testLock(WandOptions.LOCK.HORIZONTAL) || !options.testLock(WandOptions.LOCK.VERTICAL)) break;
                        candidates.add(currentCandidate.m_121955_(Direction.UP.m_122436_()).m_121955_(Direction.EAST.m_122436_()));
                        candidates.add(currentCandidate.m_121955_(Direction.UP.m_122436_()).m_121955_(Direction.WEST.m_122436_()));
                        candidates.add(currentCandidate.m_121955_(Direction.DOWN.m_122436_()).m_121955_(Direction.EAST.m_122436_()));
                        candidates.add(currentCandidate.m_121955_(Direction.DOWN.m_122436_()).m_121955_(Direction.WEST.m_122436_()));
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        if (options.testLock(WandOptions.LOCK.HORIZONTAL)) {
                            candidates.add(currentCandidate.m_121955_(Direction.NORTH.m_122436_()));
                            candidates.add(currentCandidate.m_121955_(Direction.SOUTH.m_122436_()));
                        }
                        if (options.testLock(WandOptions.LOCK.VERTICAL)) {
                            candidates.add(currentCandidate.m_121955_(Direction.UP.m_122436_()));
                            candidates.add(currentCandidate.m_121955_(Direction.DOWN.m_122436_()));
                        }
                        if (!options.testLock(WandOptions.LOCK.HORIZONTAL) || !options.testLock(WandOptions.LOCK.VERTICAL)) break;
                        candidates.add(currentCandidate.m_121955_(Direction.UP.m_122436_()).m_121955_(Direction.NORTH.m_122436_()));
                        candidates.add(currentCandidate.m_121955_(Direction.UP.m_122436_()).m_121955_(Direction.SOUTH.m_122436_()));
                        candidates.add(currentCandidate.m_121955_(Direction.DOWN.m_122436_()).m_121955_(Direction.NORTH.m_122436_()));
                        candidates.add(currentCandidate.m_121955_(Direction.DOWN.m_122436_()).m_121955_(Direction.SOUTH.m_122436_()));
                    }
                }
            }
            catch (Exception exception) {}
        }
        return destroySnapshots;
    }

    @Override
    @Nonnull
    public List<ISnapshot> getSnapshotsFromAir(Level world, Player player, BlockHitResult rayTraceResult, ItemStack wand, WandOptions options, IWandSupplier supplier, int limit) {
        return new ArrayList<ISnapshot>();
    }
}

