/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.modinit.IAStructures;
import com.craisinlord.integrated_api.utils.PlatformHooks;
import com.craisinlord.integrated_api.world.structures.JigsawStructure;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptation;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptationType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class OptionalDependencyStructure
extends JigsawStructure {
    public static final Codec<OptionalDependencyStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OptionalDependencyStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)Codec.intRange((int)1, (int)512).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.STRING.optionalFieldOf("required_mods").forGetter(structure -> structure.requiredMod), (App)Codec.STRING.optionalFieldOf("illegal_mods").forGetter(structure -> structure.illegalMod), (App)Codec.BOOL.fieldOf("rotation_fixed").orElse((Object)false).forGetter(structure -> structure.rotationFixed), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation)).apply((Applicative)instance, OptionalDependencyStructure::new));
    public final Optional<String> requiredMod;
    public final Optional<String> illegalMod;

    public OptionalDependencyStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, Optional<Integer> maxDistanceFromCenter, Optional<String> requiredMod, Optional<String> illegalMod, boolean rotationFixed, EnhancedTerrainAdaptation enhancedTerrainAdaptation) {
        super(config, startPool, size, minYAllowed, maxYAllowed, Optional.empty(), startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, maxDistanceFromCenter, Optional.empty(), rotationFixed, enhancedTerrainAdaptation);
        this.requiredMod = requiredMod;
        this.illegalMod = illegalMod;
    }

    private ArrayList<String> convertModList(String modlist) {
        int startChar = 0;
        ArrayList<String> convertedModList = new ArrayList<String>();
        for (int i = 0; i < modlist.length(); ++i) {
            if (modlist.charAt(i) != ',') continue;
            convertedModList.add(modlist.substring(startChar, i));
            startChar = i + 1;
        }
        convertedModList.add(modlist.substring(startChar));
        return convertedModList;
    }

    @Override
    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        ChunkPos chunkPos = context.f_226628_();
        if (!this.requiredMod.isEmpty()) {
            ArrayList<String> requiredMods = this.convertModList(this.requiredMod.get());
            for (String mod : requiredMods) {
                if (this.isLoaded(mod)) continue;
                IntegratedAPI.LOGGER.debug("Attempted to spawn Integrated API structure but not all required mods " + requiredMods + " are present.");
                return false;
            }
        }
        if (!this.illegalMod.isEmpty()) {
            ArrayList<String> illegalMods = this.convertModList(this.illegalMod.get());
            for (String mod : illegalMods) {
                if (!this.isLoaded(mod)) continue;
                IntegratedAPI.LOGGER.debug("Attempted to spawn Integrated API structure but illegal mods " + illegalMods + " are present.");
                return false;
            }
        }
        if (this.biomeRadius.isPresent() && !(context.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            int validBiomeRange = (Integer)this.biomeRadius.get();
            int sectionY = blockPos.m_123342_();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += context.f_226622_().m_223235_(blockPos.m_123341_(), blockPos.m_123343_(), (Heightmap.Types)this.projectStartToHeightmap.get(), context.f_226629_(), context.f_226624_());
            }
            sectionY = QuartPos.m_175400_((int)sectionY);
            for (int curChunkX = chunkPos.f_45578_ - validBiomeRange; curChunkX <= chunkPos.f_45578_ + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - validBiomeRange; curChunkZ <= chunkPos.f_45579_ + validBiomeRange; ++curChunkZ) {
                    Holder biome = context.f_226623_().m_203407_(QuartPos.m_175404_((int)curChunkX), sectionY, QuartPos.m_175404_((int)curChunkZ), context.f_226624_().m_224579_());
                    if (context.f_226630_().test(biome)) continue;
                    return false;
                }
            }
        }
        if (this.cannotSpawnInLiquid) {
            BlockPos centerOfChunk = chunkPos.m_151394_(0);
            int landHeight = context.f_226622_().m_223235_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
            NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_226629_(), context.f_226624_());
            BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        if (this.terrainHeightCheckRadius.isPresent() && (this.allowedTerrainHeightRange.isPresent() || this.minYAllowed.isPresent())) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            int terrainCheckRange = (Integer)this.terrainHeightCheckRadius.get();
            for (int curChunkX = chunkPos.f_45578_ - terrainCheckRange; curChunkX <= chunkPos.f_45578_ + terrainCheckRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - terrainCheckRange; curChunkZ <= chunkPos.f_45579_ + terrainCheckRange; ++curChunkZ) {
                    int height = context.f_226622_().m_214096_((curChunkX << 4) + 7, (curChunkZ << 4) + 7, this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG), context.f_226629_(), context.f_226624_());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                    if (this.minYAllowed.isPresent() && minTerrainHeight < (Integer)this.minYAllowed.get()) {
                        return false;
                    }
                    if (!this.maxYAllowed.isPresent() || minTerrainHeight <= (Integer)this.maxYAllowed.get()) continue;
                    return false;
                }
            }
            if (this.allowedTerrainHeightRange.isPresent() && maxTerrainHeight - minTerrainHeight > (Integer)this.allowedTerrainHeightRange.get()) {
                return false;
            }
        }
        return true;
    }

    public boolean isLoaded(String name) {
        return PlatformHooks.isModLoaded(name);
    }

    @Override
    public StructureType<?> m_213658_() {
        return IAStructures.OPTIONAL_DEPENDENCY_STRUCTURE.get();
    }
}

