/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import commoble.hyperbox.client.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class BlockPreviewRenderer
extends ModelBlockRenderer {
    private static BlockPreviewRenderer INSTANCE;

    public static BlockPreviewRenderer getInstance(ModelBlockRenderer baseRenderer) {
        if (INSTANCE == null || BlockPreviewRenderer.INSTANCE.f_110995_ != baseRenderer.f_110995_) {
            INSTANCE = new BlockPreviewRenderer(baseRenderer);
        }
        return INSTANCE;
    }

    public BlockPreviewRenderer(ModelBlockRenderer baseRenderer) {
        super(baseRenderer.f_110995_);
    }

    public static void renderBlockPreview(BlockPos pos, BlockState state, Level level, Vec3 currentRenderPos, PoseStack matrix, MultiBufferSource renderTypeBuffer) {
        matrix.m_85836_();
        double offsetX = (double)pos.m_123341_() - currentRenderPos.m_7096_();
        double offsetY = (double)pos.m_123342_() - currentRenderPos.m_7098_();
        double offsetZ = (double)pos.m_123343_() - currentRenderPos.m_7094_();
        matrix.m_85837_(offsetX, offsetY, offsetZ);
        BlockRenderDispatcher blockDispatcher = Minecraft.m_91087_().m_91289_();
        BlockPreviewRenderer renderer = BlockPreviewRenderer.getInstance(blockDispatcher.m_110937_());
        RenderType bufferType = Sheets.m_110792_();
        RenderType renderType = null;
        renderer.tesselateWithoutAO((BlockAndTintGetter)level, blockDispatcher.m_110910_(state), state, pos, matrix, renderTypeBuffer.m_6299_(bufferType), false, level.f_46441_, state.m_60726_(pos), OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
        matrix.m_85849_();
    }

    public void m_111023_(BlockAndTintGetter level, BlockState state, BlockPos pos, VertexConsumer vertexConsumer, PoseStack.Pose pose, BakedQuad quad, float tintA, float tintB, float tintC, float tintD, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float alpha = ((Double)ClientProxy.clientConfig.placementPreviewOpacity.get()).floatValue();
        if (quad.m_111304_()) {
            int i = this.f_110995_.m_92577_(state, level, pos, quad.m_111305_());
            r = (float)(i >> 16 & 0xFF) / 255.0f;
            g = (float)(i >> 8 & 0xFF) / 255.0f;
            b = (float)(i & 0xFF) / 255.0f;
        }
        vertexConsumer.putBulkData(pose, quad, new float[]{tintA, tintB, tintC, tintD}, r, g, b, alpha, new int[]{brightness0, brightness1, brightness2, brightness3}, combinedOverlayIn, true);
    }
}

