/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.client;

import commoble.hyperbox.blocks.ApertureBlockEntity;
import commoble.hyperbox.blocks.HyperboxBlockEntity;
import commoble.hyperbox.blocks.HyperboxBlockItem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ColorHandlers {
    public static final int NO_TINT = 0xFFFFFF;
    public static final int BACKGROUND_TINT = 0;

    public static int getHyperboxBlockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            if (level != null && pos != null) {
                int n;
                BlockEntity te = level.m_7702_(pos);
                if (te instanceof HyperboxBlockEntity) {
                    HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)te;
                    n = hyperbox.getColor();
                } else {
                    n = 4863306;
                }
                return n;
            }
            return 4863306;
        }
        return 0xFFFFFF;
    }

    public static int getHyperboxPreviewBlockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                return HyperboxBlockItem.getColorIfHyperbox(player.m_21205_());
            }
            return 4863306;
        }
        return 0xFFFFFF;
    }

    public static int getApertureBlockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            if (level != null && pos != null) {
                int n;
                BlockEntity te = level.m_7702_(pos);
                if (te instanceof ApertureBlockEntity) {
                    ApertureBlockEntity aperture = (ApertureBlockEntity)te;
                    n = aperture.getColor();
                } else {
                    n = 4863306;
                }
                return n;
            }
            return 4863306;
        }
        return 0xFFFFFF;
    }

    public static int getHyperboxItemColor(ItemStack stack, int tintIndex) {
        Item item = stack.m_41720_();
        if (tintIndex == 0 && item instanceof HyperboxBlockItem) {
            HyperboxBlockItem hyperboxBlockItem = (HyperboxBlockItem)item;
            return hyperboxBlockItem.m_41121_(stack);
        }
        return 0xFFFFFF;
    }
}

