/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public record PacketSerializer<T extends Consumer<NetworkEvent.Context>>(Class<T> packetClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder) {
    public static <PACKET extends Consumer<NetworkEvent.Context>> void register(int id, SimpleChannel channel, PacketSerializer<PACKET> serializer) {
        BiConsumer<Consumer, Supplier> handler = (packet, context) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)context.get();
            ctx.enqueueWork(() -> packet.accept(ctx));
            ctx.setPacketHandled(true);
        };
        channel.registerMessage(id, serializer.packetClass, serializer.encoder, serializer.decoder, handler);
    }
}

