/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class BookCommand {
    protected ResourceLocation id;
    protected Book book;
    protected String command;
    protected int permissionLevel;
    protected int maxUses;
    @Nullable
    protected String failureMessage;
    @Nullable
    protected String successMessage;

    public BookCommand(ResourceLocation id, String command, int permissionLevel, int maxUses, @Nullable String failureMessage, @Nullable String successMessage) {
        this.id = id;
        this.command = command;
        this.permissionLevel = permissionLevel;
        this.maxUses = maxUses;
        this.failureMessage = failureMessage;
        this.successMessage = successMessage;
    }

    public static BookCommand fromJson(ResourceLocation id, JsonObject json) {
        String command = GsonHelper.m_13906_((JsonObject)json, (String)"command");
        int permissionLevel = GsonHelper.m_13824_((JsonObject)json, (String)"permission_level", (int)0);
        int maxUses = GsonHelper.m_13824_((JsonObject)json, (String)"max_uses", (int)1);
        String failureMessage = GsonHelper.m_13851_((JsonObject)json, (String)"failure_message", null);
        String successMessage = GsonHelper.m_13851_((JsonObject)json, (String)"success_message", null);
        return new BookCommand(id, command, permissionLevel, maxUses, failureMessage, successMessage);
    }

    public static BookCommand fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String command = buffer.m_130277_();
        byte permissionLevel = buffer.readByte();
        int maxUses = buffer.m_130242_();
        String failureMessage = (String)buffer.m_236868_(FriendlyByteBuf::m_130277_);
        String successMessage = (String)buffer.m_236868_(FriendlyByteBuf::m_130277_);
        return new BookCommand(id, command, permissionLevel, maxUses, failureMessage, successMessage);
    }

    public void build(Book book) {
        this.book = book;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.command);
        buffer.writeByte(this.permissionLevel);
        buffer.m_130130_(this.maxUses);
        buffer.m_236821_((Object)this.failureMessage, FriendlyByteBuf::m_130070_);
        buffer.m_236821_((Object)this.successMessage, FriendlyByteBuf::m_130070_);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Book getBook() {
        return this.book;
    }

    public String getCommand() {
        return this.command;
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Nullable
    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void execute(ServerPlayer player) {
        if (!BookUnlockStateManager.get().canRunFor((Player)player, this)) {
            String failureMessage = this.failureMessage == null ? "modonomicon.command.failure" : this.failureMessage;
            player.m_213846_((Component)Component.m_237115_((String)failureMessage).m_130940_(ChatFormatting.RED));
            return;
        }
        CommandSourceStack commandSourceStack = new CommandSourceStack((CommandSource)player, player.m_20182_(), player.m_20155_(), player.m_284548_(), this.permissionLevel, player.m_7755_().getString(), player.m_5446_(), player.f_8924_, (Entity)player);
        BookUnlockStateManager.get().setRunFor((Player)player, this);
        try {
            player.f_8924_.m_129892_().m_230957_(commandSourceStack, this.command);
            if (this.successMessage != null) {
                player.m_213846_((Component)Component.m_237115_((String)this.successMessage).m_130940_(ChatFormatting.GREEN));
            }
        }
        catch (Exception e) {
            Modonomicon.LOG.error("Running command [" + this.id.toString() + "] failed: ", (Throwable)e);
        }
        BookUnlockStateManager.get().syncFor(player);
    }
}

