/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.EntryListButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class BookSearchScreen
extends BookPaginatedScreen {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    protected final List<Button> entryButtons = new ArrayList<Button>();
    private final List<BookEntry> visibleEntries = new ArrayList<BookEntry>();
    private int openPagesIndex;
    private int maxOpenPagesIndex;
    private List<BookEntry> allEntries;
    private EditBox searchField;
    private BookTextHolder infoText = new BookTextHolder("modonomicon.gui.search.info");
    private List<Component> tooltip;

    protected BookSearchScreen(BookOverviewScreen parentScreen) {
        super((Component)Component.m_237115_((String)"modonomicon.gui.search.screen.title"), parentScreen);
    }

    public void handleButtonEntry(Button button) {
        BookEntry entry = ((EntryListButton)button).getEntry();
        BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.infoText.hasComponent()) {
            this.infoText = new RenderedBookTextHolder(this.infoText, textRenderer.render(this.infoText.getString()));
        }
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color) {
        this.drawCenteredStringNoShadow(guiGraphics, s, x, y, color, 1.0f);
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.f_96547_.m_92852_((FormattedText)s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.f_96547_);
        GuiGraphicsExt.drawString(guiGraphics, this.f_96547_, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public BookOverviewScreen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.maxOpenPagesIndex;
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? --this.openPagesIndex : ++this.openPagesIndex;
            this.onPageChanged();
            if (playSound) {
                BookContentScreen.playTurnPageSound(this.parentScreen.getBook());
            }
        }
    }

    protected void drawTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.m_280666_(this.f_96547_, this.tooltip, pMouseX, pMouseY);
        }
    }

    protected void onPageChanged() {
        this.createEntryList();
    }

    protected void resetTooltip() {
        this.tooltip = null;
    }

    private void createSearchBar() {
        this.searchField = new EditBox(this.f_96547_, 160, 170, 90, 12, (Component)Component.m_237113_((String)""));
        this.searchField.m_94199_(32);
        this.searchField.m_94190_(false);
        this.searchField.m_93692_(true);
    }

    private void createEntryList() {
        this.entryButtons.forEach(b -> {
            this.f_169369_.remove(b);
            this.m_6702_().remove(b);
            this.f_169368_.remove(b);
        });
        this.entryButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.m_94155_().toLowerCase();
        this.allEntries.stream().filter(e -> e.matchesQuery(query)).forEach(this.visibleEntries::add);
        this.maxOpenPagesIndex = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxOpenPagesIndex += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.openPagesIndex;
        }
        if (this.openPagesIndex == 0) {
            this.addEntryButtons(138, 35, 0, 11);
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(12, 15, start, 13);
            this.addEntryButtons(138, 15, start + 13, 13);
        }
    }

    private int getEntryCountStart() {
        if (this.openPagesIndex == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.openPagesIndex - 1);
    }

    private List<BookEntry> getEntries() {
        return this.parentScreen.getBook().getEntries().values().stream().toList();
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Book getBook() {
        return this.parentScreen.getBook();
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.resetTooltip();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -1300.0f);
        this.m_280273_(guiGraphics);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.bookLeft, (float)this.bookTop, 0.0f);
        BookContentScreen.renderBookBackground(guiGraphics, this.getBook().getBookContentTexture());
        if (this.openPagesIndex == 0) {
            this.drawCenteredStringNoShadow(guiGraphics, this.m_96636_(), 74, 15, this.parentScreen.getBook().getDefaultTitleColor());
            this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.m_237115_((String)"modonomicon.gui.search.entry_list_title"), 203, 15, this.parentScreen.getBook().getDefaultTitleColor());
            BookContentScreen.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 74, 27);
            BookContentScreen.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 203, 27);
            BookPageRenderer.renderBookTextHolder(guiGraphics, this.infoText, this.f_96547_, 12, 37, 124);
        }
        if (!this.searchField.m_94155_().isEmpty()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BookContentScreen.drawFromTexture(guiGraphics, this.parentScreen.getBook(), this.searchField.m_252754_() - 8, this.searchField.m_252907_(), 140, 183, 99, 14);
            MutableComponent searchComponent = Component.m_237113_((String)this.searchField.m_94155_());
            guiGraphics.m_280614_(this.f_96547_, (Component)searchComponent, this.searchField.m_252754_() + 7, this.searchField.m_252907_() + 1, 0, false);
        }
        if (this.visibleEntries.isEmpty()) {
            if (!this.searchField.m_94155_().isEmpty()) {
                this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.m_237115_((String)"modonomicon.gui.search.no_results"), 203, 80, 0x333333);
                guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
                this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.m_237115_((String)"modonomicon.gui.search.sad"), 101, 47, 0x999999);
                guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            } else {
                this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.m_237115_((String)"modonomicon.gui.search.no_results"), 203, 80, 0x333333);
            }
        }
        guiGraphics.m_280168_().m_85849_();
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    public void m_7379_() {
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)256)) {
            super.m_7379_();
            this.parentScreen.m_7379_();
        } else {
            ClientServices.GUI.popGuiLayer();
        }
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int modifiers) {
        String currQuery = this.searchField.m_94155_();
        if (key == 257) {
            if (this.visibleEntries.size() == 1) {
                BookEntry entry = this.visibleEntries.get(0);
                BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
                return true;
            }
        } else if (this.searchField.m_7933_(key, scanCode, modifiers)) {
            if (!this.searchField.m_94155_().equals(currQuery)) {
                this.createEntryList();
            }
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        BookTextRenderer textRenderer = new BookTextRenderer(this.getBook());
        this.prerenderMarkdown(textRenderer);
        this.allEntries = this.getEntries().stream().filter(e -> BookUnlockStateManager.get().isUnlockedFor((Player)this.f_96541_.f_91074_, e.getCategory()) && BookUnlockStateManager.get().isUnlockedFor((Player)this.f_96541_.f_91074_, (BookEntry)e)).sorted(Comparator.comparing(a -> I18n.m_118938_((String)a.getName(), (Object[])new Object[0]))).toList();
        this.createSearchBar();
        this.createEntryList();
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (super.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return this.searchField.m_6375_(pMouseX - (double)this.bookLeft, pMouseY - (double)this.bookTop, pButton) || super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_5534_(char c, int i) {
        String currQuery = this.searchField.m_94155_();
        if (this.searchField.m_5534_(c, i)) {
            if (!this.searchField.m_94155_().equals(currQuery)) {
                this.createEntryList();
            }
            return true;
        }
        return super.m_5534_(c, i);
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            EntryListButton button = new EntryListButton(this, this.visibleEntries.get(start + i), this.bookLeft + x, this.bookTop + y + i * 11, this::handleButtonEntry);
            this.m_142416_((GuiEventListener)button);
            this.entryButtons.add(button);
        }
    }
}

