/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    private static final ClientConfig instance = new ClientConfig();
    public final QoLCategory qolCategory;
    public final ForgeConfigSpec spec;

    private ClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.qolCategory = new QoLCategory(builder);
        this.spec = builder.build();
    }

    public static ClientConfig get() {
        return instance;
    }

    public static class QoLCategory {
        public final ForgeConfigSpec.BooleanValue enableSmoothZoom;
        public final ForgeConfigSpec.BooleanValue storeLastOpenPageWhenClosingEntry;
        public final ForgeConfigSpec.ConfigValue<List<String>> fontFallbackLocales;

        public QoLCategory(ForgeConfigSpec.Builder builder) {
            builder.comment("Quality of Life Settings").push("qol");
            this.enableSmoothZoom = builder.comment("Enable smooth zoom in book categories").define("enableSmoothZoom", true);
            this.storeLastOpenPageWhenClosingEntry = builder.comment("Enable keeping the last open page stored when closing an entry. Regardless of this setting it will be stored when closing the entire book with Esc.").define("storeLastOpenPageWhenClosingEntry", false);
            ArrayList<String> fontFallbackLocalesDefault = new ArrayList<String>(List.of("zh_cn", "ja_jp", "ko_kr"));
            this.fontFallbackLocales = builder.comment("If your locale is not supported by the default Modonomicon font, indicated by the book just rendering blocky shapes instead of characters, add your locale to this list to fall back to the builtin Minecraft font.").define("fontFallbackLocales", fontFallbackLocalesDefault);
            builder.pop();
        }
    }
}

