/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import forge.NuminaObjModel;
import java.io.FileNotFoundException;
import java.util.Map;
import lehjr.numina.common.base.NuminaLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.obj.ObjMaterialLibrary;
import net.minecraftforge.client.model.obj.ObjTokenizer;

public class NuminaObjLoader
implements IGeometryLoader<NuminaObjModel>,
ResourceManagerReloadListener {
    public static NuminaObjLoader INSTANCE = new NuminaObjLoader();
    private final Map<NuminaObjModel.ModelSettings, NuminaObjModel> modelCache = Maps.newConcurrentMap();
    private final Map<ResourceLocation, ObjMaterialLibrary> materialCache = Maps.newConcurrentMap();
    private ResourceManager manager = Minecraft.m_91087_().m_91098_();

    public void m_6213_(ResourceManager resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    public NuminaObjModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        if (!jsonObject.has("model")) {
            throw new JsonParseException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = jsonObject.get("model").getAsString();
        boolean automaticCulling = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"automatic_culling", (boolean)true);
        boolean shadeQuads = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"shade_quads", (boolean)true);
        boolean flipV = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"flip_v", (boolean)false);
        boolean emissiveAmbient = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"emissive_ambient", (boolean)true);
        String mtlOverride = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"mtl_override", null);
        ImmutableMap.Builder deprecationWarningsBuilder = ImmutableMap.builder();
        if (jsonObject.has("detectCullableFaces")) {
            automaticCulling = GsonHelper.m_13912_((JsonObject)jsonObject, (String)"detectCullableFaces");
            deprecationWarningsBuilder.put((Object)"detectCullableFaces", (Object)"automatic_culling");
        }
        if (jsonObject.has("diffuseLighting")) {
            shadeQuads = GsonHelper.m_13912_((JsonObject)jsonObject, (String)"diffuseLighting");
            deprecationWarningsBuilder.put((Object)"diffuseLighting", (Object)"shade_quads");
        }
        if (jsonObject.has("flip-v")) {
            flipV = GsonHelper.m_13912_((JsonObject)jsonObject, (String)"flip-v");
            deprecationWarningsBuilder.put((Object)"flip-v", (Object)"flip_v");
        }
        if (jsonObject.has("ambientToFullbright")) {
            emissiveAmbient = GsonHelper.m_13912_((JsonObject)jsonObject, (String)"ambientToFullbright");
            deprecationWarningsBuilder.put((Object)"ambientToFullbright", (Object)"emissive_ambient");
        }
        if (jsonObject.has("materialLibraryOverride")) {
            mtlOverride = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"materialLibraryOverride");
            deprecationWarningsBuilder.put((Object)"materialLibraryOverride", (Object)"mtl_override");
        }
        return this.loadModel(new NuminaObjModel.ModelSettings(new ResourceLocation(modelLocation), automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride), (Map<String, String>)deprecationWarningsBuilder.build());
    }

    public NuminaObjModel loadWithDefaultSettings(ResourceLocation location) {
        return this.loadModel(new NuminaObjModel.ModelSettings(location, true, true, false, true, null));
    }

    public NuminaObjModel loadModel(NuminaObjModel.ModelSettings settings) {
        return this.loadModel(settings, Map.of());
    }

    private NuminaObjModel loadModel(NuminaObjModel.ModelSettings settings, Map<String, String> deprecationWarnings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            NuminaObjModel numinaObjModel;
            NuminaLogger.logDebug("numinaOBJLoader model location: " + settings.modelLocation());
            Resource resource = (Resource)this.manager.m_213713_(settings.modelLocation()).orElseThrow();
            ObjTokenizer tokenizer = new ObjTokenizer(resource.m_215507_());
            try {
                numinaObjModel = NuminaObjModel.parse(tokenizer, settings, deprecationWarnings);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        tokenizer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ model", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ model", e);
                }
            }
            tokenizer.close();
            return numinaObjModel;
        });
    }

    public ObjMaterialLibrary loadMaterialLibrary(ResourceLocation materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            ObjMaterialLibrary objMaterialLibrary;
            Resource resource = (Resource)this.manager.m_213713_(location).orElseThrow();
            ObjTokenizer rdr = new ObjTokenizer(resource.m_215507_());
            try {
                objMaterialLibrary = new ObjMaterialLibrary(rdr);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ material library", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ material library", e);
                }
            }
            rdr.close();
            return objMaterialLibrary;
        });
    }
}

