/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public ForgeConfigSpec.BooleanValue USE_FOV_FIX;
    public ForgeConfigSpec.BooleanValue USE_FOV_NORMALIZE;
    public ForgeConfigSpec.BooleanValue FOV_FIX_DEAULT_STATE;
    public ForgeConfigSpec.BooleanValue USE_SOUNDS;
    public ForgeConfigSpec.BooleanValue DEBUGGING_INFO;
    public ForgeConfigSpec.IntValue CHARGING_BASE_ENERGY_METER_GLASS_RED;
    public ForgeConfigSpec.IntValue CHARGING_BASE_ENERGY_METER_GLASS_BLUE;
    public ForgeConfigSpec.IntValue CHARGING_BASE_ENERGY_METER_GLASS_GREEN;
    public ForgeConfigSpec.IntValue CHARGING_BASE_ENERGY_METER_GLASS_ALPHA;
    public ForgeConfigSpec.IntValue CHARGING_BASE_ENERGY_METER_BAR_RED;
    public ForgeConfigSpec.IntValue CHARGING_BASE_ENERGY_METER_BAR_BLUE;
    public ForgeConfigSpec.IntValue CHARGING_BASE_ENERGY_METER_BAR_GREEN;
    public ForgeConfigSpec.IntValue CHARGING_BASE_ENERGY_METER_BAR_ALPHA;
    public ForgeConfigSpec.DoubleValue CHARGING_BASE_ENERGY_METER_DEBUG_VAL;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("General Settings").push("General");
        this.USE_FOV_FIX = builder.comment("Ignore speed boosts for field of view").translation("config.numina.useFOVFix").define("useFOVFix", true);
        this.USE_FOV_NORMALIZE = builder.comment("Use FOV Fix to normalize FOV changes").translation("config.numina.normalizeFOV").define("useFOVNormalize", true);
        this.FOV_FIX_DEAULT_STATE = builder.comment("Default state of FOVfix on login (enabled = true, disabled = false)").translation("config.numina.FOVFixDefaultState").define("fovFixDefaultState", true);
        this.USE_SOUNDS = builder.comment("Use sounds").translation("config.numina.useSounds").define("useSounds", true);
        builder.pop();
        builder.push("Charging Base Energy Meter Settings");
        this.CHARGING_BASE_ENERGY_METER_DEBUG_VAL = builder.comment("value to manually set the meter at.\n Useful for trying different colors in real time").defineInRange("chargingBaseEnergyMeterDebugValue", 0.0, 0.0, 100.0);
        this.CHARGING_BASE_ENERGY_METER_GLASS_RED = builder.comment("charging base meter glass red color amount (0 - 100)").defineInRange("chargingBaseEnergyMeterGlassRedPercent", 100, 0, 100);
        this.CHARGING_BASE_ENERGY_METER_GLASS_BLUE = builder.comment("charging base meter glass blue color amount (0 - 100)").defineInRange("chargingBaseEnergyMeterGlassBluePercent", 100, 0, 100);
        this.CHARGING_BASE_ENERGY_METER_GLASS_GREEN = builder.comment("charging base meter glass green color amount (0 - 100)").defineInRange("chargingBaseEnergyMeterGlassGreenPercent", 100, 0, 100);
        this.CHARGING_BASE_ENERGY_METER_GLASS_ALPHA = builder.comment("charging base meter glass alpha color amount (0 - 100)").defineInRange("chargingBaseEnergyMeterGlassAlphaPercent", 85, 0, 100);
        this.CHARGING_BASE_ENERGY_METER_BAR_RED = builder.comment("charging base meter bar red color amount (0 - 100)").defineInRange("chargingBaseEnergyMeterBarRedPercent", 0, 0, 100);
        this.CHARGING_BASE_ENERGY_METER_BAR_GREEN = builder.comment("charging base meter bar green color amount (0 - 100)").defineInRange("chargingBaseEnergyMeterBarGreenPercent", 100, 0, 100);
        this.CHARGING_BASE_ENERGY_METER_BAR_BLUE = builder.comment("charging base meter bar blue color amount (0 - 100)").defineInRange("chargingBaseEnergyMeterBarBluePercent", 0, 0, 100);
        this.CHARGING_BASE_ENERGY_METER_BAR_ALPHA = builder.comment("charging base meter bar alpha color amount (0 - 100)").defineInRange("chargingBaseEnergyMeterBarAlphaPercent", 85, 0, 100);
        builder.pop();
        builder.push("Development Settings");
        this.DEBUGGING_INFO = builder.comment("Enable debugging info").translation("config.numina.useDebuggingInfo").define("enableDebugging", false);
        builder.pop();
    }
}

