/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.control;

import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.player.keystates.IPlayerKeyStates;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerMovementInputWrapper {
    public static PlayerMovementInput get(Player player) {
        if (player.m_9236_().f_46443_) {
            if (player instanceof RemotePlayer) {
                return PlayerMovementInputWrapper.fromServer(player);
            }
            return PlayerMovementInputWrapper.fromClient(player);
        }
        return PlayerMovementInputWrapper.fromServer(player);
    }

    static LazyOptional<IPlayerKeyStates> getCapability(Player player) {
        return player.getCapability(NuminaCapabilities.PLAYER_KEYSTATES, null);
    }

    static PlayerMovementInput fromServer(Player player) {
        boolean forwardKey = false;
        boolean reverseKey = false;
        boolean strafeLeftKey = false;
        boolean strafeRightKey = false;
        boolean downKey = false;
        boolean jumpKey = false;
        LazyOptional<IPlayerKeyStates> playerCap = PlayerMovementInputWrapper.getCapability(player);
        if (playerCap.isPresent()) {
            forwardKey = playerCap.map(m -> m.getForwardKeyState()).orElse(false);
            reverseKey = playerCap.map(m -> m.getReverseKeyState()).orElse(false);
            strafeLeftKey = playerCap.map(m -> m.getLeftStrafeKeyState()).orElse(false);
            strafeRightKey = playerCap.map(m -> m.getRightStrafeKeyState()).orElse(false);
            downKey = playerCap.map(m -> m.getDownKeyState()).orElse(false);
            jumpKey = playerCap.map(m -> m.getJumpKeyState()).orElse(false);
        }
        return new PlayerMovementInput(forwardKey, reverseKey, strafeLeftKey, strafeRightKey, downKey, jumpKey);
    }

    static PlayerMovementInput fromClient(Player player) {
        boolean forwardKey = false;
        boolean reverseKey = false;
        boolean strafeLeftKey = false;
        boolean strafeRightKey = false;
        boolean downKey = false;
        boolean jumpKey = false;
        LazyOptional<IPlayerKeyStates> playerCap = PlayerMovementInputWrapper.getCapability(player);
        if (playerCap.isPresent()) {
            forwardKey = playerCap.map(m -> m.getForwardKeyState()).orElse(false);
            reverseKey = playerCap.map(m -> m.getReverseKeyState()).orElse(false);
            strafeLeftKey = playerCap.map(m -> m.getLeftStrafeKeyState()).orElse(false);
            strafeRightKey = playerCap.map(m -> m.getRightStrafeKeyState()).orElse(false);
            downKey = playerCap.map(m -> m.getDownKeyState()).orElse(false);
            jumpKey = playerCap.map(m -> m.getJumpKeyState()).orElse(false);
        }
        return new PlayerMovementInput(forwardKey, reverseKey, strafeLeftKey, strafeRightKey, downKey, jumpKey);
    }

    public static class PlayerMovementInput {
        public boolean forwardKey;
        public boolean reverseKey;
        public boolean strafeLeftKey;
        public boolean strafeRightKey;
        public boolean downKey;
        public boolean jumpKey;

        public PlayerMovementInput(boolean forwardKey, boolean reverseKey, boolean strafeLeftKey, boolean strafeRightKey, boolean downKey, boolean jumpKey) {
            this.forwardKey = forwardKey;
            this.reverseKey = reverseKey;
            this.strafeLeftKey = strafeLeftKey;
            this.strafeRightKey = strafeRightKey;
            this.downKey = downKey;
            this.jumpKey = jumpKey;
        }
    }
}

