/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import lehjr.numina.client.render.NuminaSpriteUploader;
import lehjr.numina.common.constants.NuminaConstants;
import lehjr.numina.common.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class NuminaIcons {
    private final NuminaSpriteUploader spriteUploader;
    private static final String iconPrefix = "gui";
    public final DrawableIcon armordisplayselect;
    public final DrawableIcon checkmark;
    public final DrawableIcon colorclicker;
    public final DrawableIcon energygeneration;
    public final DrawableIcon energystorage;
    public final DrawableIcon glowArmor;
    public final DrawableIcon lightning;
    public final DrawableIcon lightning2;
    public final DrawableIcon lightningmedium;
    public final DrawableIcon minusSign;
    public final DrawableIcon normalArmor;
    public final DrawableIcon plusSign;
    public final DrawableIcon transparentArmor;
    public final DrawableIcon weapon;

    public NuminaIcons(NuminaSpriteUploader spriteUploader) {
        this.spriteUploader = spriteUploader;
        this.armordisplayselect = this.registerIcon("armordisplayselect", 8, 8);
        this.checkmark = this.registerIcon("checkmark", 16, 16);
        this.colorclicker = this.registerIcon("colorclicker", 8, 8);
        this.energygeneration = this.registerIcon("energygeneration", 32, 32);
        this.energystorage = this.registerIcon("energystorage", 32, 32);
        this.glowArmor = this.registerIcon("glowarmor", 8, 8);
        this.lightning = this.registerIcon("lightning", 800, 62);
        this.lightning2 = this.registerIcon("lightning2", 800, 62);
        this.lightningmedium = this.registerIcon("lightningmedium", 800, 62);
        this.minusSign = this.registerIcon("minussign", 8, 8);
        this.normalArmor = this.registerIcon("normalarmor", 8, 8);
        this.plusSign = this.registerIcon("plussign", 8, 8);
        this.transparentArmor = this.registerIcon("transparentarmor", 8, 8);
        this.weapon = this.registerIcon("weapon", 16, 16);
    }

    private DrawableIcon registerIcon(String name, int width, int height) {
        ResourceLocation location = new ResourceLocation("numina", name);
        return new DrawableIcon(location, width, height);
    }

    public NuminaSpriteUploader getSpriteUploader() {
        return this.spriteUploader;
    }

    public static void renderIcon8(ResourceLocation location, PoseStack matrixStack, double left, double top, double right, double bottom, float zLevel) {
        NuminaIcons.renderIcon8(location, matrixStack, left, top, right, bottom, zLevel, Color.WHITE);
    }

    public static void renderIcon8(ResourceLocation location, PoseStack matrixStack, double left, double top, double right, double bottom, float zLevel, Color color) {
        NuminaIcons.renderTextureWithColor(location, matrixStack, left, right, top, bottom, zLevel, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, color);
    }

    public static void renderIcon16(ResourceLocation location, PoseStack matrixStack, double left, double top, double right, double bottom, float zLevel) {
        NuminaIcons.renderIcon16(location, matrixStack, left, top, right, bottom, zLevel, Color.WHITE);
    }

    public static void renderIcon16(ResourceLocation location, PoseStack matrixStack, double left, double top, double right, double bottom, float zLevel, Color color) {
        NuminaIcons.renderTextureWithColor(location, matrixStack, left, right, top, bottom, zLevel, 16.0, 16.0, 0.0, 0.0, 16.0, 16.0, color);
    }

    public static void renderTextureWithColor(ResourceLocation location, PoseStack matrixStack, double left, double right, double top, double bottom, float zLevel, double iconWidth, double iconHeight, double texStartX, double texStartY, double textureWidth, double textureHeight, Color color) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        NuminaIcons.innerBlit(matrixStack, left, right, top, bottom, zLevel, iconWidth, iconHeight, texStartX, texStartY, textureWidth, textureHeight, color);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    private static void innerBlit(PoseStack matrixStack, double left, double right, double top, double bottom, float zLevel, double iconWidth, double iconHeight, double texStartX, double texStartY, double textureWidth, double textureHeight, Color color) {
        NuminaIcons.innerBlit(matrixStack.m_85850_().m_252922_(), left, right, top, bottom, zLevel, (float)((texStartX + 0.0) / textureWidth), (float)((texStartX + iconWidth) / textureWidth), (float)((texStartY + 0.0) / textureHeight), (float)((texStartY + iconHeight) / textureHeight), color);
    }

    private static void innerBlit(Matrix4f matrix4f, double left, double right, double top, double bottom, float zLevel, float minU, float maxU, float minV, float maxV, Color color) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        color.setShaderColor();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_252986_(matrix4f, (float)left, (float)bottom, zLevel).m_7421_(minU, maxV).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)right, (float)bottom, zLevel).m_7421_(maxU, maxV).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)right, (float)top, zLevel).m_7421_(maxU, minV).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)left, (float)top, zLevel).m_7421_(minU, minV).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public void drawLightningTextured(VertexConsumer bufferIn, Matrix4f matrix4f, float x1, float y1, float z1, float x2, float y2, float z2, Color color, TextureAtlasSprite icon, float textureWidth, float textureHeight) {
        float minV = icon.m_118411_();
        float maxV = icon.m_118412_();
        float uSize = icon.m_118410_() - icon.m_118409_();
        float tx = x2 - x1;
        float ty = y2 - y1;
        float tz = z2 - z1;
        float cx = 0.0f;
        float cy = 0.0f;
        float cz = 0.0f;
        float jagfactor = 0.3f;
        while (Math.abs(cx) < Math.abs(tx) && Math.abs(cy) < Math.abs(ty) && Math.abs(cz) < Math.abs(tz)) {
            float ax = x1 + cx;
            float ay = y1 + cy;
            float az = z1 + cz;
            cx = (float)((double)cx + (Math.random() * (double)tx * (double)jagfactor - 0.1 * (double)tx));
            cy = (float)((double)cy + (Math.random() * (double)ty * (double)jagfactor - 0.1 * (double)ty));
            cz = (float)((double)cz + (Math.random() * (double)tz * (double)jagfactor - 0.1 * (double)tz));
            float bx = x1 + cx;
            float by = y1 + cy;
            float bz = z1 + cz;
            int index = this.getRandomNumber(0, 50);
            float minU = icon.m_118409_() + uSize * ((float)index * 0.2f);
            float maxU = minU + uSize * 0.2f;
            this.drawLightningBetweenPointsFast(bufferIn, matrix4f, ax, ay, az, bx, by, bz, color, minU, maxU, minV, maxV);
        }
    }

    void drawLightningBetweenPointsFast(VertexConsumer bufferIn, Matrix4f matrix4f, float x1, float y1, float z1, float x2, float y2, float z2, Color color, float minU, float maxU, float minV, float maxV) {
        float px = (y1 - y2) * 0.125f;
        float py = (x2 - x1) * 0.125f;
        bufferIn.m_252986_(matrix4f, x1 - px, y1 - py, z1).m_85950_(color.r, color.g, color.b, color.a).m_7421_(minU, minV).m_85969_(0xF000F0).m_5752_();
        bufferIn.m_252986_(matrix4f, x1 + px, y1 + py, z1).m_85950_(color.r, color.g, color.b, color.a).m_7421_(maxU, minV).m_85969_(0xF000F0).m_5752_();
        bufferIn.m_252986_(matrix4f, x2 - px, y2 - py, z2).m_85950_(color.r, color.g, color.b, color.a).m_7421_(minU, maxV).m_85969_(0xF000F0).m_5752_();
        bufferIn.m_252986_(matrix4f, x2 + px, y2 + py, z2).m_85950_(color.r, color.g, color.b, color.a).m_7421_(maxU, maxV).m_85969_(0xF000F0).m_5752_();
    }

    Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    void bindTexture() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NuminaConstants.LOCATION_NUMINA_GUI_TEXTURE_ATLAS);
    }

    int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public class DrawableIcon {
        final ResourceLocation location;
        private final int width;
        private final int height;

        protected DrawableIcon(ResourceLocation locationIn, int width, int height) {
            this.location = locationIn;
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void draw(PoseStack matrixStack, double x, double y, Color color) {
            ShaderInstance oldShader = RenderSystem.getShader();
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.enableBlend();
            this.draw(matrixStack, x, y, 0.0, 0.0, 0.0, 0.0, color);
            RenderSystem.disableBlend();
            RenderSystem.setShader(() -> oldShader);
        }

        public void renderIconScaledWithColor(PoseStack matrixStack, double posLeft, double posTop, double width, double height, Color color) {
            this.renderIconScaledWithColor(matrixStack, posLeft, posTop, width, height, 0.0f, color);
        }

        public void renderIconScaledWithColor(PoseStack matrixStack, double posLeft, double posTop, double width, double height, float zLevel, Color color) {
            NuminaIcons.this.bindTexture();
            TextureAtlasSprite icon = this.getSprite();
            ShaderInstance oldShader = RenderSystem.getShader();
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.enableBlend();
            NuminaIcons.innerBlit(matrixStack.m_85850_().m_252922_(), posLeft, posLeft + width, posTop, posTop + height, zLevel, icon.m_118409_(), icon.m_118410_(), icon.m_118411_(), icon.m_118412_(), color);
            RenderSystem.disableBlend();
            RenderSystem.setShader(() -> oldShader);
        }

        public void draw(PoseStack poseStack, double xOffset, double yOffset, double maskTop, double maskBottom, double maskLeft, double maskRight, Color color) {
            double textureWidth = this.width;
            double textureHeight = this.height;
            NuminaIcons.this.bindTexture();
            TextureAtlasSprite icon = this.getSprite();
            float zLevel = 0.0f;
            double posLeft = xOffset + maskLeft;
            double posTop = yOffset + maskTop;
            double width = textureWidth - maskRight - maskLeft;
            double height = textureHeight - maskBottom - maskTop;
            double posRight = posLeft + width;
            double posBottom = posTop + height;
            double uSize = icon.m_118410_() - icon.m_118409_();
            double vSize = icon.m_118412_() - icon.m_118411_();
            float minU = (float)((double)icon.m_118409_() + uSize * (maskLeft / textureWidth));
            float minV = (float)((double)icon.m_118411_() + vSize * (maskTop / textureHeight));
            float maxU = (float)((double)icon.m_118410_() - uSize * (maskRight / textureWidth));
            float maxV = (float)((double)icon.m_118412_() - vSize * (maskBottom / textureHeight));
            NuminaIcons.innerBlit(poseStack.m_85850_().m_252922_(), posLeft, posRight, posTop, posBottom, zLevel, minU, maxU, minV, maxV, color);
        }

        public TextureAtlasSprite getSprite() {
            return NuminaIcons.this.spriteUploader.m_118901_(this.location);
        }

        public String toString() {
            TextureAtlasSprite icon = this.getSprite();
            if (icon != null) {
                return "icon: " + icon;
            }
            return "icon is null for location: " + this.location.toString();
        }

        public void drawLightning(MultiBufferSource bufferIn, PoseStack matrixStack, float x1, float y1, float z1, float x2, float y2, float z2, Color color) {
            TextureAtlasSprite icon = this.getSprite();
            NuminaIcons.this.bindTexture();
            NuminaIcons.this.drawLightningTextured(bufferIn.m_6299_(RenderType.m_110502_()), matrixStack.m_85850_().m_252922_(), x1, y1, z1, x2, y2, z2, color, icon, this.width, this.height);
        }
    }
}

