/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import com.mojang.blaze3d.systems.RenderSystem;
import lehjr.numina.client.gui.NuminaIcons;
import lehjr.numina.client.gui.clickable.Clickable;
import lehjr.numina.client.gui.geometry.IDrawable;
import lehjr.numina.client.gui.geometry.IDrawableRect;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.gui.geometry.Rect;
import lehjr.numina.common.math.Color;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class Checkbox
extends Clickable {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/checkbox.png");
    private final boolean showLabel;
    protected boolean isChecked;
    protected CheckboxTile tile;
    Component label;

    @Deprecated
    public Checkbox(MusePoint2D position, String displayString, boolean isChecked) {
        this(position, (Component)Component.m_237113_((String)displayString), isChecked);
    }

    @Deprecated
    public Checkbox(MusePoint2D position, Component displayString, boolean isChecked) {
        this(position, displayString, isChecked, true);
    }

    public Checkbox(MusePoint2D position, Component displayString, boolean isChecked, boolean showLabel) {
        super(MusePoint2D.ZERO, MusePoint2D.ZERO);
        this.setPosition(position);
        this.makeNewTile();
        this.label = displayString;
        this.isChecked = isChecked;
        this.enableAndShow();
        this.showLabel = showLabel;
        this.setHeight(20.0);
    }

    public Checkbox(double left, double top, int width, Component message, boolean checked) {
        super(new Rect(left, top, left + (double)width, top + 20.0));
        this.isChecked = checked;
        this.label = message;
        this.showLabel = true;
    }

    public Checkbox(double posX, double posY, double width, Component message, boolean checked, boolean showLabel) {
        this(new MusePoint2D(posX, posY), message, checked, showLabel);
        this.setWidth(width);
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(gfx, mouseX, mouseY, partialTick);
        if (this.isVisible()) {
            this.makeNewTile();
            this.tile.m_88315_(gfx, mouseX, mouseY, partialTick);
            if (this.showLabel) {
                StringUtils.drawShadowedString(gfx, this.label, this.tile.centerX() + 10.0, this.tile.centerY() - 4.0, Color.WHITE);
            }
        }
    }

    void makeNewTile() {
        if (this.tile == null) {
            MusePoint2D ul = new MusePoint2D(this.left() + 2.0, this.centerY() - 5.0);
            this.tile = new CheckboxTile(ul);
        } else {
            this.tile.setUL(new MusePoint2D(this.left() + 2.0, this.centerY() - 5.0));
        }
    }

    @Override
    public boolean containsPoint(double x, double y) {
        return this.isVisible() && this.isEnabled() ? this.tile.containsPoint(x, y) : false;
    }

    @Override
    public void setPosition(MusePoint2D position) {
        super.setPosition(position);
        if (this.tile == null) {
            this.makeNewTile();
        }
        this.tile.setPosition(position);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.isChecked = !this.isChecked;
        }
        super.onPressed();
    }

    class CheckboxTile
    extends Rect
    implements IDrawableRect {
        public CheckboxTile(MusePoint2D ul) {
            super(ul, ul.plus(10.0, 10.0));
        }

        @Override
        public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.enableBlend();
            NuminaIcons.renderTextureWithColor(TEXTURE, gfx.m_280168_(), this.left(), this.right(), this.top(), this.bottom(), this.getZLevel(), 20.0, 20.0, Checkbox.this.containsPoint(mouseX, mouseY) ? 20.0 : 0.0, Checkbox.this.isChecked() ? 20.0 : 0.0, 64.0, 64.0, Color.WHITE);
            RenderSystem.disableBlend();
        }

        @Override
        public float getZLevel() {
            return 0.0f;
        }

        @Override
        public IDrawable setZLevel(float zLevel) {
            return this;
        }
    }
}

