/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import lehjr.numina.client.gui.clickable.Clickable;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class ModularItemTabToggleWidget
extends Clickable {
    protected ResourceLocation resourceLocation;
    protected boolean isStateActive = false;
    protected double xTexStart;
    protected double yTexStart;
    protected double xDiffTex;
    protected double yDiffTex;
    private float animationTime;
    @Nonnull
    ItemStack icon;
    EquipmentSlot type;

    public ModularItemTabToggleWidget(EquipmentSlot type) {
        super(0.0, 0.0, 35.0, 27.0, false);
        this.initTextureValues(153, 2, 35, 0, new ResourceLocation("textures/gui/recipe_book.png"));
        this.type = type;
        LocalPlayer player = this.getMinecraft().f_91074_;
        ItemStack test = ItemUtils.getItemFromEntitySlot((LivingEntity)player, type);
        this.icon = test.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iItemHandler -> test).orElse(ItemStack.f_41583_);
    }

    public void initTextureValues(int pXTexStart, int pYTexStart, int pXDiffTex, int pYDiffTex, ResourceLocation pResourceLocation) {
        this.xTexStart = pXTexStart;
        this.yTexStart = pYTexStart;
        this.xDiffTex = pXDiffTex;
        this.yDiffTex = pYDiffTex;
        this.resourceLocation = pResourceLocation;
    }

    public void setStateActive(boolean active) {
        this.isStateActive = active;
    }

    public EquipmentSlot getSlotType() {
        return this.type;
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        if (this.animationTime > 0.0f) {
            float f = 1.0f + 0.1f * (float)Math.sin(this.animationTime / 15.0f * (float)Math.PI);
            gfx.m_280168_().m_85836_();
            gfx.m_280168_().m_252880_((float)(this.left() + 8.0), (float)(this.top() + 12.0), 0.0f);
            gfx.m_280168_().m_85841_(1.0f, f, 1.0f);
            gfx.m_280168_().m_252880_((float)(-(this.left() + 8.0)), (float)(-(this.top() + 12.0)), 0.0f);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        RenderSystem.disableDepthTest();
        float i = (float)this.xTexStart;
        float j = (float)this.yTexStart;
        if (this.isStateActive) {
            i = (float)((double)i + this.xDiffTex);
        }
        if (this.containsPoint(mouseX, mouseY)) {
            j = (float)((double)j + this.yDiffTex);
        }
        float k = (float)this.left();
        if (this.isStateActive) {
            k -= 2.0f;
        }
        IconUtils.INSTANCE.blit(gfx.m_280168_(), k, (float)this.top(), i, j, (float)this.width(), (float)this.height());
        RenderSystem.enableDepthTest();
        this.renderIcon(gfx);
        if (this.animationTime > 0.0f) {
            gfx.m_280168_().m_85849_();
            this.animationTime -= partialTick;
        }
    }

    private void renderIcon(GuiGraphics gfx) {
        int offset = this.isStateActive ? -2 : -2;
        RenderSystem.disableDepthTest();
        if (this.icon.m_41619_()) {
            if (EquipmentSlot.MAINHAND.equals((Object)this.type)) {
                RenderSystem.setShader(GameRenderer::m_172820_);
                IconUtils.INSTANCE.getIcon().weapon.draw(gfx.m_280168_(), this.left() + 9.0 + (double)offset, this.top() + 5.0, Color.WHITE);
            } else {
                Pair<ResourceLocation, ResourceLocation> pair = IconUtils.getSlotBackground(this.type);
                if (pair != null) {
                    TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.getMinecraft().m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureatlassprite.m_247685_());
                    gfx.m_280159_((int)this.left() + 10 + offset, (int)this.top() + 5, 0, 16, 16, textureatlassprite);
                }
            }
            RenderSystem.enableDepthTest();
        } else {
            gfx.m_280480_(this.icon, (int)this.left() + 9 + offset, (int)this.top() + 6);
            gfx.m_280370_(Minecraft.m_91087_().f_91062_, this.icon, (int)this.left() + 9 + offset, (int)this.top() + 6);
        }
    }
}

