/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.frame;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import lehjr.numina.client.gui.frame.IGuiFrame;
import lehjr.numina.client.gui.geometry.IDrawableRect;
import lehjr.numina.common.math.Color;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public interface IScrollable
extends IGuiFrame,
IDrawableRect {
    public void setTotalSize(int var1);

    public int getButtonSize();

    public void setButtonSize(int var1);

    public int getTotalSize();

    public double getCurrentScrollPixels();

    public void setCurrentScrollPixels(double var1);

    default public double getMaxScrollPixels() {
        return Math.max((double)this.getTotalSize() - this.height(), 0.0);
    }

    default public double getScrollAmount() {
        return 8.0;
    }

    default public void setScrollAmount(double scrollAmount) {
        this.setCurrentScrollPixels((int)MathUtils.clampDouble(scrollAmount, 0.0, this.getMaxScrollPixels()));
    }

    @Override
    default public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.containsPoint(mouseX, mouseY)) {
            this.setCurrentScrollPixels((int)MathUtils.clampDouble(this.getCurrentScrollPixels() - dWheel * this.getScrollAmount(), 0.0, this.getMaxScrollPixels()));
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseClicked(double x, double y, int button) {
        if (this.isVisible() && this.containsPoint(x, y) && button == 0) {
            double dscroll = 0.0;
            if (y - this.top() < (double)this.getButtonSize() && this.getCurrentScrollPixels() > 0.0) {
                dscroll -= this.getScrollAmount();
            } else if (this.bottom() - y < (double)this.getButtonSize()) {
                dscroll += this.getScrollAmount();
            }
            if (dscroll != 0.0) {
                this.setCurrentScrollPixels(MathUtils.clampDouble(this.getCurrentScrollPixels() + dscroll, 0.0, this.getMaxScrollPixels()));
            }
            return true;
        }
        return false;
    }

    @Override
    default public void preRender(GuiGraphics gfx, int mouseX, int mouseY, float frameTIme) {
        if (this.isVisible()) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.enableBlend();
            Lighting.m_166384_();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85816_);
            Matrix4f matrix4f = gfx.m_280168_().m_85850_().m_252922_();
            if (this.getCurrentScrollPixels() + this.height() < (double)this.getTotalSize()) {
                buffer.m_252986_(matrix4f, (float)(this.left() + this.width() / 2.0), (float)this.bottom(), this.getZLevel()).m_85950_(Color.LIGHT_BLUE.r, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.a).m_85969_(0xF000F0).m_5752_();
                buffer.m_252986_(matrix4f, (float)(this.left() + this.width() / 2.0 + 2.0), (float)this.bottom() - 4.0f, this.getZLevel()).m_85950_(Color.LIGHT_BLUE.r, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.a).m_85969_(0xF000F0).m_5752_();
                buffer.m_252986_(matrix4f, (float)(this.left() + this.width() / 2.0 - 2.0), (float)this.bottom() - 4.0f, this.getZLevel()).m_85950_(Color.LIGHT_BLUE.r, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.a).m_85969_(0xF000F0).m_5752_();
            }
            if (this.getCurrentScrollPixels() > 0.0) {
                buffer.m_252986_(matrix4f, (float)(this.left() + this.width() / 2.0), (float)this.top(), this.getZLevel()).m_85950_(Color.LIGHT_BLUE.r, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.a).m_85969_(0xF000F0).m_5752_();
                buffer.m_252986_(matrix4f, (float)(this.left() + this.width() / 2.0 - 2.0), (float)this.top() + 4.0f, this.getZLevel()).m_85950_(Color.LIGHT_BLUE.r, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.a).m_85969_(0xF000F0).m_5752_();
                buffer.m_252986_(matrix4f, (float)(this.left() + this.width() / 2.0 + 2.0), (float)this.top() + 4.0f, this.getZLevel()).m_85950_(Color.LIGHT_BLUE.r, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.b, Color.LIGHT_BLUE.a).m_85969_(0xF000F0).m_5752_();
            }
            tessellator.m_85914_();
            RenderSystem.disableBlend();
            IScrollable.enableScissor((int)this.left(), (int)this.top(), (int)this.width(), (int)this.height());
        }
    }

    public static void enableScissor(double x, double y, double w, double h) {
        Minecraft mc = Minecraft.m_91087_();
        int dh = mc.m_91268_().m_85442_();
        double scaleFactor = mc.m_91268_().m_85449_();
        double newx = x * scaleFactor;
        double newy = (double)dh - h * scaleFactor - y * scaleFactor;
        double neww = w * scaleFactor;
        double newh = h * scaleFactor;
        RenderSystem.enableScissor((int)((int)newx), (int)((int)newy), (int)((int)neww), (int)((int)newh));
    }

    @Override
    default public void postRender(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            RenderSystem.disableScissor();
        }
    }
}

