/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.frame;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import lehjr.numina.client.gui.IContainerULOffSet;
import lehjr.numina.client.gui.frame.ScrollableFrame;
import lehjr.numina.client.gui.geometry.IDrawable;
import lehjr.numina.client.gui.geometry.IDrawableRect;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.gui.geometry.Rect;
import lehjr.numina.client.gui.slot.IHideableSlot;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.apache.commons.lang3.tuple.Pair;

public abstract class InventoryFrame
extends ScrollableFrame
implements IContainerULOffSet {
    IContainerULOffSet.ulGetter ulGetter;
    AbstractContainerMenu container;
    public final int gridWidth;
    protected List<Integer> slotIndexes;
    List<SlotRect> tiles;
    MusePoint2D slot_ulShift = new MusePoint2D(0.0, 0.0);
    int slotWidth = 18;
    int slotHeight = 18;
    int numVisibleRows = -1;
    int scrollLimit = -1;
    int currentScroll = 0;

    public InventoryFrame(Rect rect, AbstractContainerMenu containerIn, int gridWidth, List<Integer> slotIndexesIn, IContainerULOffSet.ulGetter ulGetter2) {
        super(rect);
        this.ulGetter = ulGetter2;
        this.container = containerIn;
        this.gridWidth = gridWidth;
        this.slotIndexes = slotIndexesIn;
        this.tiles = new ArrayList<SlotRect>();
        this.setNewValues(slotIndexesIn);
    }

    public InventoryFrame setNewValues(List<Integer> slotIndexesIn) {
        for (int index : this.slotIndexes) {
            Slot slot = this.container.m_38853_(index);
            if (!(slot instanceof IHideableSlot)) continue;
            ((IHideableSlot)slot).disable();
            ((IHideableSlot)slot).setPosition(new MusePoint2D(-1000.0, -1000.0));
        }
        this.slotIndexes = slotIndexesIn;
        int totalRows = (int)Math.ceil((double)slotIndexesIn.size() / (double)this.gridWidth);
        if ((double)(totalRows * this.slotHeight) > this.height()) {
            this.numVisibleRows = (int)Math.ceil(this.height() / (double)this.slotHeight);
            this.scrollLimit = totalRows - this.numVisibleRows;
        }
        this.loadSlots();
        return this;
    }

    Pair<Integer, Integer> getVisibleRows() {
        int totalRows = this.getTotalRows();
        this.numVisibleRows = (int)Math.ceil(this.height() / (double)this.slotHeight);
        if (this.numVisibleRows < totalRows) {
            return Pair.of((Object)this.currentScroll, (Object)(this.numVisibleRows + this.currentScroll));
        }
        return Pair.of((Object)0, (Object)this.numVisibleRows);
    }

    int getTotalRows() {
        return (int)Math.ceil((double)this.slotIndexes.size() / (double)this.gridWidth);
    }

    public void loadSlots() {
        this.tiles = new ArrayList<SlotRect>();
        if (this.slotIndexes.isEmpty()) {
            return;
        }
        this.slot_ulShift = this.getULShift();
        Pair<Integer, Integer> gridRange = this.getVisibleRows();
        MusePoint2D ul = new MusePoint2D(this.left(), this.top());
        int i = (Integer)gridRange.getLeft() * this.gridWidth;
        for (int row = ((Integer)gridRange.getLeft()).intValue(); row < (Integer)gridRange.getRight(); ++row) {
            for (int col = 0; col < this.gridWidth; ++col) {
                if (i >= this.slotIndexes.size()) {
                    return;
                }
                this.tiles.add(this.getNewRect(ul.plus(this.slot_ulShift)));
                if (i > 0) {
                    if (col > 0) {
                        this.tiles.get(i).setRightOf(this.tiles.get(i - 1));
                    }
                    if (row > 0) {
                        this.tiles.get(i).setBelow(this.tiles.get(i - this.gridWidth));
                    }
                }
                MusePoint2D position = new MusePoint2D(this.tiles.get(i).left(), this.tiles.get(i).top()).minus(this.slot_ulShift);
                Slot slot = this.container.m_38853_(this.slotIndexes.get(i).intValue());
                if (slot instanceof IHideableSlot) {
                    ((IHideableSlot)slot).setPosition(position);
                    ((IHideableSlot)slot).enable();
                } else {
                    slot.f_40220_ = (int)position.x();
                    slot.f_40221_ = (int)position.y();
                }
                ++i;
            }
        }
    }

    public SlotRect getNewRect(MusePoint2D ul) {
        return new SlotRect(ul);
    }

    public InventoryFrame setSlotWidth(int slotWidthIn) {
        this.slotWidth = slotWidthIn;
        this.setWH(new MusePoint2D(this.slotWidth, this.slotHeight));
        return this;
    }

    public InventoryFrame setSlotHeight(int slotHeightIn) {
        this.slotHeight = slotHeightIn;
        this.setWH(new MusePoint2D(this.slotWidth, this.slotHeight));
        return this;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.containsPoint(mouseX, mouseY)) {
            this.currentScroll = (int)MathUtils.clampDouble((double)this.currentScroll + dWheel, 0.0, this.scrollLimit > 0 ? this.scrollLimit : 0);
            return true;
        }
        return false;
    }

    @Override
    public void update(double mouseX, double mouseY) {
        super.update(mouseX, mouseY);
        this.loadSlots();
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        if (this.tiles != null && !this.tiles.isEmpty()) {
            for (SlotRect tile : this.tiles) {
                tile.m_88315_(gfx, mouseX, mouseY, partialTick);
            }
        }
    }

    @Override
    public List<Component> getToolTip(int i, int i1) {
        return null;
    }

    @Override
    public void setULGetter(IContainerULOffSet.ulGetter ulGetter2) {
        this.ulGetter = ulGetter2;
    }

    @Override
    public MusePoint2D getULShift() {
        int offset = 16;
        if (this.ulGetter == null) {
            return new MusePoint2D(0.0, 0.0).plus((double)(offset - this.slotWidth) * 0.5, (double)(offset - this.slotHeight) * 0.5);
        }
        return this.ulGetter.getULShift().plus((double)(offset - this.slotWidth) * 0.5, (double)(offset - this.slotHeight) * 0.5);
    }

    class SlotRect
    extends Rect
    implements IDrawableRect {
        public final ResourceLocation BACKGROUND;
        float zLevel;

        public SlotRect(MusePoint2D ul) {
            super(ul, ul.plus(InventoryFrame.this.slotWidth, InventoryFrame.this.slotHeight));
            this.BACKGROUND = new ResourceLocation("numina", "textures/gui/container/slot_rect.png");
            this.zLevel = 0.0f;
        }

        @Override
        public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.BACKGROUND);
            IconUtils.blit(gfx.m_280168_(), this.left(), this.top(), (double)this.getZLevel(), 0.0, 0.0, this.width(), this.height(), 18.0, 18.0);
        }

        @Override
        public float getZLevel() {
            this.zLevel = 0.0f;
            return 0.0f;
        }

        @Override
        public IDrawable setZLevel(float zLevel) {
            this.zLevel = zLevel;
            return this;
        }
    }
}

