/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.geometry;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.FloatBuffer;
import lehjr.numina.client.gui.geometry.IDrawable;
import lehjr.numina.client.gui.geometry.IDrawableRect;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.gui.geometry.Rect;
import lehjr.numina.common.math.Color;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;

public class DrawableTile
extends Rect
implements IDrawableRect {
    final float lineWidth = 1.0f;
    Color topBorderColor = new Color(0.216f, 0.216f, 0.216f, 1.0f);
    Color bottomBorderColor = Color.WHITE.withAlpha(0.8f);
    Color backgroundColor = new Color(0.545f, 0.545f, 0.545f, 1.0f);
    float zLevel = 0.0f;
    float shrinkBoarderBy = 0.0f;

    public DrawableTile(double left, double top, double right, double bottom, boolean growFromMiddle) {
        super(left, top, right, bottom, growFromMiddle);
    }

    public DrawableTile(double left, double top, double right, double bottom) {
        super(left, top, right, bottom, false);
    }

    public DrawableTile(MusePoint2D ul, MusePoint2D br) {
        super(ul, br);
    }

    public DrawableTile setTopBorderColor(Color topBorderColor) {
        this.topBorderColor = topBorderColor;
        return this;
    }

    public Color getTopBorderColor() {
        return this.topBorderColor;
    }

    public DrawableTile setBottomBorderColor(Color bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
        return this;
    }

    public Color getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public DrawableTile setBackgroundColor(Color insideColor) {
        this.backgroundColor = insideColor;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public DrawableTile setBorderShrinkValue(float shrinkBy) {
        this.shrinkBoarderBy = shrinkBy;
        return this;
    }

    public void internalDraw(GuiGraphics gfx, Color color, VertexFormat.Mode mode, double shrinkBy) {
        this.internalDrawRect(gfx, this.left() + shrinkBy, this.top() + shrinkBy, this.right() - shrinkBy, this.bottom() - shrinkBy, color, mode);
    }

    public void internalDrawRect(GuiGraphics gfx, double left, double top, double right, double bottom, Color colorIn, VertexFormat.Mode mode) {
        BufferBuilder builder = this.preDraw(mode, DefaultVertexFormat.f_85815_);
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)8);
        Matrix4f matrix4f = gfx.m_280168_().m_85850_().m_252922_();
        vertices.put((float)right);
        vertices.put((float)top);
        vertices.put((float)left);
        vertices.put((float)top);
        vertices.put((float)left);
        vertices.put((float)bottom);
        vertices.put((float)right);
        vertices.put((float)bottom);
        vertices.flip();
        vertices.rewind();
        this.addVerticesToBuffer(builder, matrix4f, vertices, colorIn);
        builder.m_231175_();
        this.postDraw(builder);
    }

    public void drawBackground(GuiGraphics gfx) {
        this.internalDraw(gfx, this.backgroundColor, VertexFormat.Mode.QUADS, 0.0);
    }

    public void drawBorder(GuiGraphics gfx, double shrinkBy) {
        this.internalDraw(gfx, this.topBorderColor, VertexFormat.Mode.DEBUG_LINES, shrinkBy);
    }

    public void drawDualColorBorder(GuiGraphics gfx, float shrinkBy) {
        float halfWidth = 0.5f;
        this.internalDrawRect(gfx, this.left() + (double)shrinkBy - (double)halfWidth, this.top() + (double)shrinkBy - (double)halfWidth, this.right() - (double)shrinkBy + (double)halfWidth, this.top() + (double)shrinkBy + (double)halfWidth, this.topBorderColor, VertexFormat.Mode.QUADS);
        this.internalDrawRect(gfx, this.left() + (double)shrinkBy - (double)halfWidth, this.top() + (double)shrinkBy - (double)halfWidth, this.left() + (double)shrinkBy + (double)halfWidth, this.bottom() - (double)shrinkBy + (double)halfWidth, this.topBorderColor, VertexFormat.Mode.QUADS);
        this.internalDrawRect(gfx, this.left() + (double)shrinkBy - (double)halfWidth, this.bottom() - (double)shrinkBy - (double)halfWidth, this.right() - (double)shrinkBy + (double)halfWidth, this.bottom() - (double)shrinkBy + (double)halfWidth, this.bottomBorderColor, VertexFormat.Mode.QUADS);
        this.internalDrawRect(gfx, this.right() - (double)shrinkBy - (double)halfWidth, this.top() + (double)shrinkBy - (double)halfWidth, this.right() - (double)shrinkBy + (double)halfWidth, this.bottom() - (double)shrinkBy + (double)halfWidth, this.bottomBorderColor, VertexFormat.Mode.QUADS);
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.drawBackground(gfx);
        if (this.topBorderColor.equals(this.bottomBorderColor)) {
            this.drawBorder(gfx, this.shrinkBoarderBy);
        } else {
            this.drawDualColorBorder(gfx, this.shrinkBoarderBy);
        }
    }

    @Override
    public float getZLevel() {
        return this.zLevel;
    }

    @Override
    public IDrawable setZLevel(float zLevelIn) {
        this.zLevel = zLevelIn;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder(super.toString());
        stringbuilder.append("Background Color: ").append(this.backgroundColor).append("\n");
        stringbuilder.append("Top Border Color: ").append(this.topBorderColor).append("\n");
        stringbuilder.append("Bottom Border Color: ").append(this.bottomBorderColor).append("\n");
        return stringbuilder.toString();
    }
}

