/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.geometry;

import lehjr.numina.client.gui.geometry.FlyFromPointToPoint2D;
import lehjr.numina.client.gui.geometry.IRect;
import lehjr.numina.client.gui.geometry.MusePoint2D;

public class Rect
implements IRect {
    MusePoint2D ul;
    MusePoint2D wh;
    protected IRect belowMe;
    protected IRect aboveMe;
    protected IRect leftOfMe;
    protected IRect rightOfMe;

    public Rect(double left, double top, double right, double bottom) {
        this(left, top, right, bottom, false);
    }

    public Rect(double left, double top, double right, double bottom, boolean growFromMiddle) {
        this(new MusePoint2D(left, top), new MusePoint2D(right, bottom), growFromMiddle);
    }

    public Rect(MusePoint2D ul, MusePoint2D br) {
        this(ul, br, false);
    }

    public Rect(MusePoint2D ul, MusePoint2D br, boolean growFromMiddle) {
        this.ul = ul;
        this.wh = br.minus(ul);
        if (growFromMiddle) {
            MusePoint2D center = ul.plus(this.wh.times(0.5));
            this.ul = new FlyFromPointToPoint2D(center, ul, 200.0);
            this.wh = new FlyFromPointToPoint2D(new MusePoint2D(0.0, 0.0), this.wh, 200.0);
        }
    }

    @Override
    public double top() {
        if (this.aboveMe != null) {
            return this.aboveMe.bottom();
        }
        return this.ul.y();
    }

    @Override
    public Rect setTop(double value) {
        this.ul.setY(value);
        return this;
    }

    @Override
    public double left() {
        if (this.leftOfMe != null) {
            return this.leftOfMe.right();
        }
        return this.ul.x();
    }

    @Override
    public Rect setLeft(double value) {
        this.ul.setX(value);
        return this;
    }

    @Override
    public double bottom() {
        if (this.belowMe != null) {
            return this.belowMe.top();
        }
        return this.top() + this.wh.y();
    }

    @Override
    public Rect setBottom(double value) {
        this.wh.y = value - this.ul.y();
        return this;
    }

    @Override
    public double right() {
        if (this.rightOfMe != null) {
            return this.rightOfMe.left();
        }
        return this.left() + this.wh.x();
    }

    @Override
    public Rect setRight(double value) {
        this.wh.x = value - this.ul.x();
        return this;
    }

    @Override
    public double width() {
        return this.wh.x();
    }

    @Override
    public double height() {
        return this.wh.y();
    }

    @Override
    public Rect setWidth(double value) {
        this.wh.setX(value);
        return this;
    }

    @Override
    public Rect setHeight(double value) {
        this.wh.setY(value);
        return this;
    }

    @Override
    public MusePoint2D getUL() {
        return this.ul;
    }

    @Override
    public Rect setUL(MusePoint2D ul) {
        this.ul = ul;
        return this;
    }

    @Override
    public MusePoint2D getWH() {
        return this.wh;
    }

    @Override
    public Rect setWH(MusePoint2D wh) {
        this.wh = wh;
        return this;
    }

    @Override
    public Rect setAbove(IRect belowMe) {
        this.belowMe = belowMe;
        return this;
    }

    @Override
    public Rect setLeftOf(IRect rightOfMe) {
        this.rightOfMe = rightOfMe;
        return this;
    }

    @Override
    public Rect setBelow(IRect aboveMe) {
        this.aboveMe = aboveMe;
        return this;
    }

    @Override
    public Rect setRightOf(IRect leftOfMe) {
        this.leftOfMe = leftOfMe;
        return this;
    }

    @Override
    public void moveBy(MusePoint2D amount) {
        IRect.super.moveBy(amount);
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(this.getClass()).append(":\n");
        stringbuilder.append("Left: ").append(this.left()).append("\n");
        stringbuilder.append("Top: ").append(this.top()).append("\n");
        stringbuilder.append("Right: ").append(this.right()).append("\n");
        stringbuilder.append("Bottom: ").append(this.bottom()).append("\n");
        stringbuilder.append("Width: ").append(this.width()).append("\n");
        stringbuilder.append("Height: ").append(this.height()).append("\n");
        stringbuilder.append("UL: ").append(this.getUL()).append("\n");
        stringbuilder.append("WH: ").append(this.getWH()).append("\n");
        return stringbuilder.toString();
    }
}

