/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.meter;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.concurrent.Callable;
import lehjr.numina.client.config.IMeterConfig;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.common.constants.NuminaConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class HeatMeter {
    final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("minecraft:block/lava_still");
    final int xsize = 32;
    final int ysize = 8;
    float meterStart;
    float meterLevel;
    Callable<IMeterConfig> config;

    public HeatMeter(Callable<IMeterConfig> config) {
        this.config = config;
    }

    private HeatMeter() {
        this.config = () -> new IMeterConfig(){};
    }

    public TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(this.TEXTURE_LOCATION);
    }

    IMeterConfig getConfig() {
        try {
            return this.config.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new IMeterConfig(){};
        }
    }

    public void draw(GuiGraphics gfx, float xpos, float ypos, float value) {
        value = Mth.m_14036_((float)(value + this.getConfig().getDebugValue()), (float)0.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172820_);
        this.drawFluid(gfx, xpos, ypos, value, this.getTexture());
        this.drawGlass(gfx, xpos, ypos);
        RenderSystem.disableBlend();
    }

    public void drawFluid(GuiGraphics gfx, float xpos, float ypos, float value, TextureAtlasSprite icon) {
        value = Math.min(value, 1.0f);
        gfx.m_280168_().m_85836_();
        gfx.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        this.meterStart = xpos;
        this.meterLevel = xpos + 32.0f * value;
        while (this.meterStart + 8.0f < this.meterLevel) {
            IconUtils.drawIconAt(gfx.m_280168_(), this.meterStart * 2.0f, ypos * 2.0f, icon, this.getConfig().getBarColor());
            this.meterStart += 8.0f;
        }
        IconUtils.drawIconPartial(gfx.m_280168_(), this.meterStart * 2.0f, ypos * 2.0f, icon, this.getConfig().getBarColor(), 0.0, 0.0, (this.meterLevel - this.meterStart) * 2.0f, 16.0);
        gfx.m_280168_().m_85849_();
    }

    public void drawGlass(GuiGraphics gfx, float xpos, float ypos) {
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float blitOffset = 0.0f;
        float left = xpos;
        float right = left + 32.0f;
        float top = ypos;
        float bottom = top + 8.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NuminaConstants.GLASS_TEXTURE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f matrix4f = gfx.m_280168_().m_85850_().m_252922_();
        bufferbuilder.m_252986_(matrix4f, left, bottom, blitOffset).m_7421_(maxU, maxV).m_85950_(this.getConfig().getGlassColor().r, this.getConfig().getGlassColor().g, this.getConfig().getGlassColor().b, this.getConfig().getGlassColor().a).m_5752_();
        bufferbuilder.m_252986_(matrix4f, right, bottom, blitOffset).m_7421_(maxU, minV).m_85950_(this.getConfig().getGlassColor().r, this.getConfig().getGlassColor().g, this.getConfig().getGlassColor().b, this.getConfig().getGlassColor().a).m_5752_();
        bufferbuilder.m_252986_(matrix4f, right, top, blitOffset).m_7421_(minU, minV).m_85950_(this.getConfig().getGlassColor().r, this.getConfig().getGlassColor().g, this.getConfig().getGlassColor().b, this.getConfig().getGlassColor().a).m_5752_();
        bufferbuilder.m_252986_(matrix4f, left, top, blitOffset).m_7421_(minU, maxV).m_85950_(this.getConfig().getGlassColor().r, this.getConfig().getGlassColor().g, this.getConfig().getGlassColor().b, this.getConfig().getGlassColor().a).m_5752_();
        tesselator.m_85914_();
    }
}

