/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.model.item.armor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lehjr.numina.common.capabilities.render.modelspec.ObjPartSpec;
import lehjr.numina.common.math.Color;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.TransformationHelper;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class RenderOBJPart
extends ModelPart {
    public float xOffset = 0.0f;
    public float yOffset = 0.0f;
    public float zOffset = 0.0f;
    public float xRotOffset = 0.0f;
    public float yRotOffset = 0.0f;
    public float zRotOffset = 0.0f;
    final int FULL_BRIGHTNESS = 0xF000F0;
    final float div255 = 0.003921569f;
    ModelPart parent;

    public RenderOBJPart(Model base, ModelPart parent) {
        super(new ArrayList(), new HashMap());
        this.parent = parent;
    }

    public void m_104315_(ModelPart pModelPart) {
        this.f_233553_ = pModelPart.f_233553_;
        this.f_233554_ = pModelPart.f_233554_;
        this.f_233555_ = pModelPart.f_233555_;
        this.f_104203_ = pModelPart.f_104203_ + this.xRotOffset;
        this.f_104204_ = pModelPart.f_104204_ + this.yRotOffset;
        this.f_104205_ = pModelPart.f_104205_ + this.zRotOffset;
        this.f_104200_ = pModelPart.f_104200_ + this.xOffset;
        this.f_104201_ = pModelPart.f_104201_ + this.yOffset;
        this.f_104202_ = pModelPart.f_104202_ + this.zOffset;
    }

    public void render(ObjPartSpec partSpec, CompoundTag tag, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, Color color) {
        partSpec.getPart().ifPresent(objBakedPart -> {
            if (this.f_104207_) {
                ImmutableList.Builder builder = ImmutableList.builder();
                RandomSource random = RandomSource.m_216335_((long)42L);
                builder.addAll(objBakedPart.m_213637_(null, null, random));
                poseStack.m_85836_();
                this.m_104299_(poseStack);
                this.renderQuads(poseStack.m_85850_(), buffer, (List<BakedQuad>)builder.build(), packedLight, packedOverlay, color.getARGBInt());
                poseStack.m_85849_();
            }
        });
    }

    public void m_104299_(PoseStack matrixStackIn) {
        matrixStackIn.m_252880_(0.0f, -this.yOffset * 0.0625f, 0.0f);
        super.m_104299_(matrixStackIn);
        matrixStackIn.m_252781_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(180.0f, 0.0f, 0.0f), (boolean)true));
        matrixStackIn.m_252880_(0.0f, -this.yOffset * 0.0625f, 0.0f);
    }

    public void renderQuads(PoseStack.Pose entry, VertexConsumer bufferIn, List<BakedQuad> quadsIn, int combinedLightIn, int combinedOverlayIn, int color) {
        float a = (float)(color >> 24 & 0xFF) * 0.003921569f;
        float r = (float)(color >> 16 & 0xFF) * 0.003921569f;
        float g = (float)(color >> 8 & 0xFF) * 0.003921569f;
        float b = (float)(color & 0xFF) * 0.003921569f;
        for (BakedQuad bakedquad : quadsIn) {
            this.addVertexData(bufferIn, entry, bakedquad, combinedLightIn, combinedOverlayIn, r, g, b, a);
        }
    }

    void addVertexData(VertexConsumer bufferIn, PoseStack.Pose matrixEntry, BakedQuad bakedQuad, int lightmapCoordIn, int overlayCoords, float red, float green, float blue, float alpha) {
        int[] aint = bakedQuad.m_111303_();
        Vec3i faceNormal = bakedQuad.m_111306_().m_122436_();
        Matrix4f matrix4f = matrixEntry.m_252922_();
        Vector3f normal = matrixEntry.m_252943_().transform(new Vector3f((float)faceNormal.m_123341_(), (float)faceNormal.m_123342_(), (float)faceNormal.m_123343_()));
        float scale = 0.0625f;
        int intSize = DefaultVertexFormat.f_85811_.m_86017_();
        int vertexCount = aint.length / intSize;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int vert = 0; vert < vertexCount; ++vert) {
                ((Buffer)intbuffer).clear();
                intbuffer.put(aint, vert * 8, 8);
                float x = bytebuffer.getFloat(0);
                float y = bytebuffer.getFloat(4);
                float z = bytebuffer.getFloat(8);
                int lightmapCoord = bufferIn.applyBakedLighting(lightmapCoordIn, bytebuffer);
                float u = bytebuffer.getFloat(16);
                float v = bytebuffer.getFloat(20);
                Vector4f pos = matrix4f.transform(new Vector4f(x * scale, y * scale, z * scale, 1.0f));
                bufferIn.applyBakedNormals(normal, bytebuffer, matrixEntry.m_252943_());
                bufferIn.m_5954_(pos.x(), pos.y(), pos.z(), red, green, blue, alpha, u, v, overlayCoords, lightmapCoord, normal.x(), normal.y(), normal.z());
            }
        }
    }

    public void m_104301_(PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay) {
    }

    public void m_104306_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
    }
}

