/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import lehjr.numina.client.model.helper.ModelTransformCalibration;
import lehjr.numina.client.model.item.armor.ArmorModelInstance;
import lehjr.numina.client.model.item.armor.HighPolyArmor;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.capabilities.render.IModelSpec;
import lehjr.numina.common.capabilities.render.modelspec.JavaPartSpec;
import lehjr.numina.common.capabilities.render.modelspec.NuminaModelSpecRegistry;
import lehjr.numina.common.capabilities.render.modelspec.ObjPartSpec;
import lehjr.numina.common.capabilities.render.modelspec.PartSpecBase;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.math.Color;
import lehjr.numina.common.tags.NBTTagAccessor;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class NuminaArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    ModelTransformCalibration CALIBRATION;
    final ResourceLocation powersuitsTransparentArmor = new ResourceLocation("powersuits", "transparent_armor");

    public NuminaArmorLayer(RenderLayerParent<T, M> entityRenderer, A modelLeggings, A modelArmor, ModelManager modelManager) {
        super(entityRenderer, modelLeggings, modelArmor, modelManager);
        this.CALIBRATION = ModelTransformCalibration.CALIBRATION;
    }

    Optional<IModelSpec> getRenderCapability(ItemStack itemStack) {
        return itemStack.getCapability(NuminaCapabilities.RENDER).filter(IModelSpec.class::isInstance).map(IModelSpec.class::cast);
    }

    public void m_6494_(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Arrays.stream(EquipmentSlot.values()).filter(equipmentSlot -> equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR).forEach(slot -> this.m_117118_(matrixStackIn, bufferIn, entityIn, (EquipmentSlot)slot, packedLightIn, this.getModelFromSlot((EquipmentSlot)slot)));
    }

    private A getModelFromSlot(EquipmentSlot slot) {
        return (A)(this.isLegSlot(slot) ? this.f_117071_ : this.f_117072_);
    }

    private boolean isLegSlot(EquipmentSlot slotIn) {
        return slotIn == EquipmentSlot.LEGS;
    }

    protected void m_117125_(A model, EquipmentSlot pSlot) {
        model.m_8009_(false);
        switch (pSlot) {
            case HEAD: {
                ((HumanoidModel)model).f_102808_.f_104207_ = true;
                ((HumanoidModel)model).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)model).f_102810_.f_104207_ = true;
                ((HumanoidModel)model).f_102811_.f_104207_ = true;
                ((HumanoidModel)model).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)model).f_102810_.f_104207_ = true;
                ((HumanoidModel)model).f_102813_.f_104207_ = true;
                ((HumanoidModel)model).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)model).f_102813_.f_104207_ = true;
                ((HumanoidModel)model).f_102814_.f_104207_ = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_117118_(PoseStack poseStack, MultiBufferSource bufferIn, T entityIn, EquipmentSlot slotIn, int packedLightIn, A model) {
        ItemStack itemstack = ItemUtils.getItemFromEntitySlot(entityIn, slotIn);
        Optional<IModelSpec> renderCapabity = this.getRenderCapability(itemstack);
        Item item = itemstack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armoritem = (ArmorItem)item;
            if (itemstack.getCapability(NuminaCapabilities.RENDER).isPresent()) {
                if (armoritem.m_266204_().m_266308_() != slotIn) return;
                if (this.doesBypassRender(itemstack)) {
                    return;
                }
                renderCapabity.ifPresent(renderCap -> {
                    CompoundTag renderTag = renderCap.getRenderTagOrDefault();
                    if (renderTag != null && !renderTag.m_128456_()) {
                        int[] colors = renderTag.m_128465_("colors");
                        if (colors.length == 0) {
                            colors = new int[]{Color.WHITE.getARGBInt()};
                        }
                        for (CompoundTag tag : NBTTagAccessor.getValues(renderTag)) {
                            VertexConsumer consumer;
                            PartSpecBase partSpec = NuminaModelSpecRegistry.getInstance().getPart(tag);
                            if (partSpec == null) continue;
                            int ix = partSpec.getColorIndex(tag);
                            int partColor = ix < colors.length && ix >= 0 ? colors[ix] : -1;
                            Color color = new Color(partColor);
                            boolean glow = partSpec.getGlow(tag);
                            if (partSpec instanceof JavaPartSpec) {
                                ResourceLocation location = ((JavaPartSpec)partSpec).getTextureLocation();
                                ((HumanoidModel)this.m_117386_()).m_102872_(model);
                                ModelPart part = partSpec.getBinding().getTarget().apply((HumanoidModel)model);
                                poseStack.m_85836_();
                                if (part != null) {
                                    part.m_104299_(poseStack);
                                    consumer = this.getVertexConsumer(bufferIn, location, glow);
                                    part.m_104290_(poseStack.m_85850_(), consumer, glow ? 0xF000F0 : packedLightIn, OverlayTexture.f_118083_, color.r, color.g, color.b, color.a);
                                }
                                poseStack.m_85849_();
                                continue;
                            }
                            if (!(partSpec instanceof ObjPartSpec)) continue;
                            Transformation transform = this.CALIBRATION.getTransform();
                            if (transform != Transformation.m_121093_()) {
                                poseStack.pushTransformation(transform);
                            }
                            HighPolyArmor highPolyArmor = ArmorModelInstance.getInstance();
                            highPolyArmor.copyPropertiesFrom((HumanoidModel)this.m_117386_());
                            consumer = this.getVertexConsumer(bufferIn, TextureAtlas.f_118259_, glow);
                            highPolyArmor.renderToBuffer((ObjPartSpec)partSpec, tag, poseStack, consumer, glow ? 0xF000F0 : packedLightIn, OverlayTexture.f_118083_, color);
                            if (transform == Transformation.m_121093_()) continue;
                            poseStack.m_85849_();
                        }
                    }
                });
                return;
            }
        }
        super.m_117118_(poseStack, bufferIn, entityIn, slotIn, packedLightIn, model);
    }

    boolean doesBypassRender(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(handler -> handler.isModuleOnline(this.powersuitsTransparentArmor)).orElse(false);
    }

    VertexConsumer getVertexConsumer(MultiBufferSource buffer, ResourceLocation location, boolean glow) {
        if (glow) {
            return buffer.m_6299_(RenderType.m_110460_((ResourceLocation)location, (boolean)true));
        }
        return buffer.m_6299_(RenderType.m_110470_((ResourceLocation)location));
    }
}

